"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OTHER_CATEGORY_LABEL = exports.OTHER_CATEGORY_DEFAULT_COLOR = void 0;
exports.assignCategoriesToPalette = assignCategoriesToPalette;
exports.dynamicRound = dynamicRound;
exports.getComputedFieldName = getComputedFieldName;
exports.getComputedFieldNamePrefix = getComputedFieldNamePrefix;
exports.getHasLabel = getHasLabel;
exports.makeMbClampedNumberExpression = makeMbClampedNumberExpression;
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OTHER_CATEGORY_LABEL = _i18n.i18n.translate('xpack.maps.styles.categorical.otherCategoryLabel', {
  defaultMessage: 'Other'
});
exports.OTHER_CATEGORY_LABEL = OTHER_CATEGORY_LABEL;
const OTHER_CATEGORY_DEFAULT_COLOR = _uiTheme.euiThemeVars.euiColorLightShade;
exports.OTHER_CATEGORY_DEFAULT_COLOR = OTHER_CATEGORY_DEFAULT_COLOR;
function getComputedFieldName(styleName, fieldName) {
  return `${getComputedFieldNamePrefix(fieldName)}__${styleName}`;
}
function getComputedFieldNamePrefix(fieldName) {
  return `__kbn__dynamic__${fieldName}`;
}
function dynamicRound(value) {
  if (typeof value !== 'number') {
    return value;
  }
  let precision = 0;
  let threshold = 10;
  while (value < threshold && precision < 8) {
    precision++;
    threshold = threshold / 10;
  }
  return precision === 0 ? Math.round(value) : parseFloat(value.toFixed(precision + 1));
}
function assignCategoriesToPalette({
  categories,
  paletteValues
}) {
  const stops = [];
  let fallbackSymbolId = null;
  if (categories.length && paletteValues.length) {
    const maxLength = Math.min(paletteValues.length, categories.length + 1);
    fallbackSymbolId = paletteValues[maxLength - 1];
    for (let i = 0; i < maxLength - 1; i++) {
      stops.push({
        stop: categories[i].key,
        style: paletteValues[i],
        iconSource: _constants.ICON_SOURCE.MAKI
      });
    }
  }
  return {
    stops,
    fallbackSymbolId
  };
}
function makeMbClampedNumberExpression({
  lookupFunction,
  fieldName,
  minValue,
  maxValue,
  fallback
}) {
  const clamp = ['max', ['min', ['to-number', [lookupFunction, fieldName]], maxValue], minValue];
  return ['coalesce', ['case', ['==', [lookupFunction, fieldName], null], fallback,
  // == does a JS-y like check where returns true for null and undefined
  clamp], fallback];
}
function getHasLabel(label) {
  return label.isDynamic() ? label.isComplete() : label.getOptions().value != null && label.getOptions().value.length > 0;
}