"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoLineForm = GeoLineForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _single_field_select = require("../../../../components/single_field_select");
var _index_pattern_util = require("../../../../index_pattern_util");
var _i18n_constants = require("./i18n_constants");
var _group_by_button_group = require("./group_by_button_group");
var _group_by_label = require("./group_by_label");
var _size_slider = require("./size_slider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GeoLineForm(props) {
  const isTimeseries = (0, _react.useMemo)(() => {
    return (0, _index_pattern_util.getIsTimeseries)(props.indexPattern);
  }, [props.indexPattern]);
  function onSortFieldChange(fieldName) {
    if (fieldName !== undefined) {
      props.onSortFieldChange(fieldName);
    }
  }
  function onSplitFieldChange(fieldName) {
    if (fieldName !== undefined) {
      props.onSplitFieldChange(fieldName);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isTimeseries && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_group_by_label.GroupByLabel, null),
    display: props.isColumnCompressed ? 'columnCompressed' : 'row'
  }, /*#__PURE__*/_react.default.createElement(_group_by_button_group.GroupByButtonGroup, {
    groupByTimeseries: props.groupByTimeseries,
    onGroupByTimeseriesChange: props.onGroupByTimeseriesChange
  })), props.groupByTimeseries ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.esGeoLine.lineSImplificationSizeLabel', {
      defaultMessage: 'Simplification threshold'
    }),
    helpText: _i18n.i18n.translate('xpack.maps.esGeoLine.lineSImplificationSizeHelpText', {
      defaultMessage: 'The maximum number of points for each track. Track is simplifed when threshold is exceeded. Use smaller values for better performance.'
    }),
    display: props.isColumnCompressed ? 'columnCompressed' : 'row'
  }, /*#__PURE__*/_react.default.createElement(_size_slider.SizeSlider, {
    value: props.lineSimplificationSize,
    onChange: props.onLineSimplificationSizeChange
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n_constants.ENTITY_INPUT_LABEL,
    display: props.isColumnCompressed ? 'columnCompressed' : 'row'
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.maps.source.esGeoLine.splitFieldPlaceholder', {
      defaultMessage: 'Select entity field'
    }),
    value: props.splitField,
    onChange: onSplitFieldChange,
    fields: (0, _index_pattern_util.getTermsFields)(props.indexPattern.fields),
    isClearable: false,
    compressed: props.isColumnCompressed
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n_constants.SORT_INPUT_LABEL,
    display: props.isColumnCompressed ? 'columnCompressed' : 'row'
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.maps.source.esGeoLine.sortFieldPlaceholder', {
      defaultMessage: 'Select sort field'
    }),
    value: props.sortField,
    onChange: onSortFieldChange,
    fields: props.indexPattern.fields.filter(field => {
      const isSplitField = props.splitField ? field.name === props.splitField : false;
      return !isSplitField && field.sortable && !_public.indexPatterns.isNestedField(field) && ['number', 'date'].includes(field.type);
    }),
    isClearable: false,
    compressed: props.isColumnCompressed
  }))));
}