"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Mask = exports.BUCKETS = exports.BELOW = exports.ABOVE = void 0;
exports.getMaskI18nDescription = getMaskI18nDescription;
exports.getMaskI18nLabel = getMaskI18nLabel;
exports.getMaskI18nValue = getMaskI18nValue;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BELOW = _i18n.i18n.translate('xpack.maps.mask.belowLabel', {
  defaultMessage: 'below'
});
exports.BELOW = BELOW;
const ABOVE = _i18n.i18n.translate('xpack.maps.mask.aboveLabel', {
  defaultMessage: 'above'
});
exports.ABOVE = ABOVE;
const BUCKETS = _i18n.i18n.translate('xpack.maps.mask.genericBucketsName', {
  defaultMessage: 'buckets'
});
exports.BUCKETS = BUCKETS;
const FEATURES = _i18n.i18n.translate('xpack.maps.mask.genericFeaturesName', {
  defaultMessage: 'features'
});
const VALUE = _i18n.i18n.translate('xpack.maps.mask.genericAggLabel', {
  defaultMessage: 'value'
});
const WHEN = _i18n.i18n.translate('xpack.maps.mask.when', {
  defaultMessage: 'when'
});
const WHEN_JOIN_METRIC = _i18n.i18n.translate('xpack.maps.mask.whenJoinMetric', {
  defaultMessage: '{whenLabel} join metric',
  values: {
    whenLabel: WHEN
  }
});
function getOperatorLabel(operator) {
  if (operator === _constants.MASK_OPERATOR.BELOW) {
    return BELOW;
  }
  if (operator === _constants.MASK_OPERATOR.ABOVE) {
    return ABOVE;
  }
  return operator;
}
function getMaskI18nValue(operator, value) {
  return `${getOperatorLabel(operator)} ${value}`;
}
function getMaskI18nLabel({
  bucketsName,
  isJoin
}) {
  return _i18n.i18n.translate('xpack.maps.mask.maskLabel', {
    defaultMessage: 'Hide {hideNoun}',
    values: {
      hideNoun: isJoin ? FEATURES : bucketsName ? bucketsName : BUCKETS
    }
  });
}
function getMaskI18nDescription({
  aggLabel,
  bucketsName,
  isJoin
}) {
  return _i18n.i18n.translate('xpack.maps.mask.maskDescription', {
    defaultMessage: '{maskAdverb} {aggLabel} is ',
    values: {
      aggLabel: aggLabel ? aggLabel : VALUE,
      maskAdverb: isJoin ? WHEN_JOIN_METRIC : WHEN
    }
  });
}
class Mask {
  constructor({
    esAggField,
    isGeometrySourceMvt,
    operator,
    value
  }) {
    (0, _defineProperty2.default)(this, "_esAggField", void 0);
    (0, _defineProperty2.default)(this, "_isGeometrySourceMvt", void 0);
    (0, _defineProperty2.default)(this, "_operator", void 0);
    (0, _defineProperty2.default)(this, "_value", void 0);
    this._esAggField = esAggField;
    this._isGeometrySourceMvt = isGeometrySourceMvt;
    this._operator = operator;
    this._value = value;
  }
  _isFeatureState() {
    if (this._esAggField.getOrigin() === _constants.FIELD_ORIGIN.SOURCE) {
      // source fields are stored in properties
      return false;
    }
    if (!this._isGeometrySourceMvt) {
      // For geojson sources, join fields are stored in properties
      return false;
    }

    // For vector tile sources, it is not possible to add join fields to properties
    // so join fields are stored in feature state
    return true;
  }

  /*
   * Returns maplibre expression that matches masked features
   */
  getMatchMaskedExpression() {
    const comparisionOperator = this._operator === _constants.MASK_OPERATOR.BELOW ? '<' : '>';
    const lookup = this._isFeatureState() ? _constants.MB_LOOKUP_FUNCTION.FEATURE_STATE : _constants.MB_LOOKUP_FUNCTION.GET;
    return [comparisionOperator, [lookup, this._esAggField.getMbFieldName()], this._value];
  }

  /*
   * Returns maplibre expression that matches unmasked features
   */
  getMatchUnmaskedExpression() {
    const comparisionOperator = this._operator === _constants.MASK_OPERATOR.BELOW ? '>=' : '<=';
    const lookup = this._isFeatureState() ? _constants.MB_LOOKUP_FUNCTION.FEATURE_STATE : _constants.MB_LOOKUP_FUNCTION.GET;
    return [comparisionOperator, [lookup, this._esAggField.getMbFieldName()], this._value];
  }
  getEsAggField() {
    return this._esAggField;
  }
  getFieldOriginListLabel() {
    const source = this._esAggField.getSource();
    const isJoin = this._esAggField.getOrigin() === _constants.FIELD_ORIGIN.JOIN;
    const maskLabel = getMaskI18nLabel({
      bucketsName: 'getBucketsName' in source ? source.getBucketsName() : undefined,
      isJoin
    });
    const adverb = isJoin ? WHEN_JOIN_METRIC : WHEN;
    return `${maskLabel} ${adverb}`;
  }
  getOperator() {
    return this._operator;
  }
  getValue() {
    return this._value;
  }
  isFeatureMasked(feature) {
    const featureValue = this._isFeatureState() ? feature === null || feature === void 0 ? void 0 : feature.state[this._esAggField.getMbFieldName()] : feature === null || feature === void 0 ? void 0 : feature.properties[this._esAggField.getMbFieldName()];
    if (typeof featureValue !== 'number') {
      return false;
    }
    return this._operator === _constants.MASK_OPERATOR.BELOW ? featureValue < this._value : featureValue > this._value;
  }
}
exports.Mask = Mask;