"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMeasuredCharacterDimensions = exports.unwrappedContentStyle = exports.preWrappedContentStyle = exports.monospaceTextStyle = exports.longWrappedContentStyle = exports.hoveredContentStyle = exports.highlightedContentStyle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const monospaceTextStyle = scale => (0, _common.css)`
  font-family: ${props => props.theme.eui.euiCodeFontFamily};
  font-size: ${props => {
  switch (scale) {
    case 'large':
      return props.theme.eui.euiFontSizeM;
    case 'medium':
      return props.theme.eui.euiFontSizeS;
    case 'small':
      return props.theme.eui.euiFontSizeXS;
    default:
      return props.theme.eui.euiFontSize;
  }
}};
  line-height: ${props => props.theme.eui.euiLineHeight};
`;
exports.monospaceTextStyle = monospaceTextStyle;
const hoveredContentStyle = (0, _common.css)`
  background-color: ${props => props.theme.eui.euiFocusBackgroundColor};
`;
exports.hoveredContentStyle = hoveredContentStyle;
const highlightedContentStyle = (0, _common.css)`
  background-color: ${props => props.theme.eui.euiColorHighlight};
`;
exports.highlightedContentStyle = highlightedContentStyle;
const longWrappedContentStyle = (0, _common.css)`
  overflow: visible;
  white-space: pre-wrap;
  word-break: break-all;
`;
exports.longWrappedContentStyle = longWrappedContentStyle;
const preWrappedContentStyle = (0, _common.css)`
  overflow: hidden;
  white-space: pre;
`;
exports.preWrappedContentStyle = preWrappedContentStyle;
const unwrappedContentStyle = (0, _common.css)`
  overflow: hidden;
  white-space: nowrap;
`;
exports.unwrappedContentStyle = unwrappedContentStyle;
const useMeasuredCharacterDimensions = scale => {
  const [dimensions, setDimensions] = (0, _react.useState)({
    height: 0,
    width: 0
  });
  const measureElement = (0, _react.useCallback)(element => {
    if (!element) {
      return;
    }
    const boundingBox = element.getBoundingClientRect();
    setDimensions({
      height: boundingBox.height,
      width: boundingBox.width
    });
  }, []);
  const CharacterDimensionsProbe = (0, _react.useMemo)(() => () => /*#__PURE__*/_react.default.createElement(MonospaceCharacterDimensionsProbe, {
    scale: scale,
    ref: measureElement
  }, "X"), [measureElement, scale]);
  return {
    CharacterDimensionsProbe,
    dimensions
  };
};
exports.useMeasuredCharacterDimensions = useMeasuredCharacterDimensions;
const MonospaceCharacterDimensionsProbe = _common.euiStyled.div.attrs(() => ({
  'aria-hidden': true
}))`
  visibility: hidden;
  position: absolute;
  height: auto;
  width: auto;
  padding: 0;
  margin: 0;

  ${props => monospaceTextStyle(props.scale)};
`;