"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSelection = void 0;
var _datasets = require("../../../../common/datasets");
var _dataset_selection = require("../../../../common/dataset_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateSelection = ({
  datasetsClient
}) => context => async send => {
  var _context$datasetSelec;
  const unresolvedIntegrationName = (_context$datasetSelec = context.datasetSelection.selection.dataset.parentIntegration) === null || _context$datasetSelec === void 0 ? void 0 : _context$datasetSelec.name;
  const unresolvedDatasetName = context.datasetSelection.selection.dataset.name;
  if (context.datasetSelection.selectionType !== 'unresolved' || !unresolvedIntegrationName) {
    return send('LISTEN_TO_CHANGES');
  }
  try {
    const {
      items
    } = await datasetsClient.findIntegrations({
      nameQuery: unresolvedIntegrationName
    });

    // There should only be one matching integration with the given name
    // If no integration matches, skip the update and listen for user changes
    const installedIntegration = items[0];
    if (!installedIntegration) {
      return send('LISTEN_TO_CHANGES');
    }

    // If no dataset matches the passed name for the retrieved integration,
    // skip the update and listen for user changes
    const targetDataset = installedIntegration.datasets.find(d => d.name === unresolvedDatasetName);
    if (!targetDataset) {
      return send('LISTEN_TO_CHANGES');
    }
    const dataset = _datasets.Dataset.create(targetDataset, installedIntegration);
    const datasetSelection = _dataset_selection.SingleDatasetSelection.create(dataset);
    send({
      type: 'UPDATE_DATASET_SELECTION',
      data: datasetSelection
    });
  } catch (error) {
    return send('DATASET_SELECTION_RESTORE_FAILURE');
  }
};
exports.validateSelection = validateSelection;