"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controlPanelConfigs = exports.availableControlsPanels = exports.availableControlPanelFields = exports.DEFAULT_CONTEXT = exports.CONTROL_PANELS_URL_KEY = void 0;
var _dataset_selection = require("../../../../common/dataset_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CONTEXT = {
  datasetSelection: _dataset_selection.AllDatasetSelection.create()
};
exports.DEFAULT_CONTEXT = DEFAULT_CONTEXT;
const CONTROL_PANELS_URL_KEY = 'controlPanels';
exports.CONTROL_PANELS_URL_KEY = CONTROL_PANELS_URL_KEY;
const availableControlsPanels = {
  NAMESPACE: 'data_stream.namespace'
};
exports.availableControlsPanels = availableControlsPanels;
const controlPanelConfigs = {
  [availableControlsPanels.NAMESPACE]: {
    order: 0,
    width: 'medium',
    grow: false,
    type: 'optionsListControl',
    explicitInput: {
      id: availableControlsPanels.NAMESPACE,
      fieldName: availableControlsPanels.NAMESPACE,
      title: 'Namespace'
    }
  }
};
exports.controlPanelConfigs = controlPanelConfigs;
const availableControlPanelFields = Object.values(availableControlsPanels);
exports.availableControlPanelFields = availableControlPanelFields;