"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsClient = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _datasets = require("../../../common/datasets");
var _latest = require("../../../common/latest");
var _errors = require("../../../common/datasets/errors");
var _runtime_types = require("../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultIntegrationsParams = {
  dataStreamType: 'logs'
};
const defaultDatasetsParams = {
  type: 'logs',
  uncategorisedOnly: true
};
class DatasetsClient {
  constructor(http) {
    this.http = http;
  }
  async findIntegrations(params = {}) {
    const search = {
      ...defaultIntegrationsParams,
      ...params
    };
    const query = _latest.findIntegrationsRequestQueryRT.encode(search);
    const response = await this.http.get(_latest.INTEGRATIONS_URL, {
      query,
      version: _common.API_VERSIONS.public.v1
    }).catch(error => {
      throw new _errors.FindIntegrationsError(`Failed to fetch integrations": ${error}`);
    });
    const data = (0, _runtime_types.decodeOrThrow)(_latest.findIntegrationsResponseRT, message => new _errors.FindIntegrationsError(`Failed to decode integrations response: ${message}"`))(response);
    return {
      ...data,
      items: data.items.map(_datasets.Integration.create)
    };
  }
  async findDatasets(params = {}) {
    const search = {
      ...defaultDatasetsParams,
      ...params
    };
    const query = _latest.findDatasetsRequestQueryRT.encode(search);
    const response = await this.http.get(_latest.DATASETS_URL, {
      query,
      version: _common.API_VERSIONS.public.v1
    }).catch(error => {
      throw new _errors.FindDatasetsError(`Failed to fetch data streams": ${error}`);
    });
    const data = (0, _runtime_types.decodeOrThrow)(_latest.findDatasetsResponseRT, message => new _errors.FindDatasetsError(`Failed to decode data streams response: ${message}"`))(response);
    return {
      items: data.items.map(dataset => _datasets.Dataset.create(dataset))
    };
  }
}
exports.DatasetsClient = DatasetsClient;