"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewsContext = exports.DataViewsProvider = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _react2 = require("@xstate/react");
var _data_views = require("../state_machines/data_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataViews = ({
  dataViewsService,
  discoverService
}) => {
  const dataViewsStateService = (0, _react2.useInterpret)(() => (0, _data_views.createDataViewsStateMachine)({
    dataViews: dataViewsService,
    discover: discoverService
  }));
  const dataViews = (0, _react2.useSelector)(dataViewsStateService, state => state.context.dataViews);
  const error = (0, _react2.useSelector)(dataViewsStateService, state => state.context.error);
  const isLoading = (0, _react2.useSelector)(dataViewsStateService, state => state.matches('loading'));
  const loadDataViews = (0, _react.useCallback)(() => dataViewsStateService.send({
    type: 'LOAD_DATA_VIEWS'
  }), [dataViewsStateService]);
  const reloadDataViews = (0, _react.useCallback)(() => dataViewsStateService.send({
    type: 'RELOAD_DATA_VIEWS'
  }), [dataViewsStateService]);
  const searchDataViews = (0, _react.useCallback)(searchParams => dataViewsStateService.send({
    type: 'SEARCH_DATA_VIEWS',
    search: searchParams
  }), [dataViewsStateService]);
  const selectDataView = (0, _react.useCallback)(dataView => dataViewsStateService.send({
    type: 'SELECT_DATA_VIEW',
    dataView
  }), [dataViewsStateService]);
  const sortDataViews = (0, _react.useCallback)(searchParams => dataViewsStateService.send({
    type: 'SORT_DATA_VIEWS',
    search: searchParams
  }), [dataViewsStateService]);
  return {
    // Underlying state machine
    dataViewsStateService,
    // Failure states
    error,
    // Loading states
    isLoading,
    // Data
    dataViews,
    // Actions
    loadDataViews,
    reloadDataViews,
    searchDataViews,
    selectDataView,
    sortDataViews
  };
};
const [DataViewsProvider, useDataViewsContext] = (0, _constate.default)(useDataViews);
exports.useDataViewsContext = useDataViewsContext;
exports.DataViewsProvider = DataViewsProvider;