"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CustomFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _flyout_detail = require("../components/flyout_detail/flyout_detail");
var _use_log_explorer_customizations = require("../hooks/use_log_explorer_customizations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFlyoutContent = ({
  actions,
  dataView,
  doc,
  renderDefaultContent
}) => {
  const {
    flyout
  } = (0, _use_log_explorer_customizations.useLogExplorerCustomizationsContext)();
  const renderPreviousContent = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_flyout_detail.FlyoutDetail, {
    actions: actions,
    dataView: dataView,
    doc: doc
  }))), [actions, dataView, doc]);
  const content = flyout !== null && flyout !== void 0 && flyout.renderContent ? flyout === null || flyout === void 0 ? void 0 : flyout.renderContent(renderPreviousContent, {
    doc
  }) : renderPreviousContent();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, content, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, renderDefaultContent()));
};

// eslint-disable-next-line import/no-default-export
exports.CustomFlyoutContent = CustomFlyoutContent;
var _default = CustomFlyoutContent;
exports.default = _default;