"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceAccordionTitle = exports.otherAccordionTitle = exports.infraAccordionTitle = exports.flyoutTraceLabel = exports.flyoutShipperLabel = exports.flyoutServiceLabel = exports.flyoutOrchestratorResourceIdLabel = exports.flyoutOrchestratorClusterNameLabel = exports.flyoutNamespaceLabel = exports.flyoutMessageLabel = exports.flyoutLogPathFileLabel = exports.flyoutHoverActionToggleColumnText = exports.flyoutHoverActionFilterOutText = exports.flyoutHoverActionFilterForText = exports.flyoutHoverActionFilterForFieldPresentText = exports.flyoutHoverActionCopyToClipboardText = exports.flyoutHostNameLabel = exports.flyoutDatasetLabel = exports.flyoutCloudRegionLabel = exports.flyoutCloudProviderLabel = exports.flyoutCloudProjectIdLabel = exports.flyoutCloudInstanceIdLabel = exports.flyoutCloudAvailabilityZoneLabel = exports.flyoutAccordionShowMoreText = exports.cloudAccordionTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flyoutMessageLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.message', {
  defaultMessage: 'Message'
});
exports.flyoutMessageLabel = flyoutMessageLabel;
const flyoutServiceLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.service', {
  defaultMessage: 'Service'
});
exports.flyoutServiceLabel = flyoutServiceLabel;
const flyoutTraceLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.trace', {
  defaultMessage: 'Trace'
});
exports.flyoutTraceLabel = flyoutTraceLabel;
const flyoutHostNameLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.hostName', {
  defaultMessage: 'Host name'
});
exports.flyoutHostNameLabel = flyoutHostNameLabel;
const serviceAccordionTitle = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.accordion.title.service', {
  defaultMessage: 'Service'
});
exports.serviceAccordionTitle = serviceAccordionTitle;
const infraAccordionTitle = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.accordion.title.infrastructure', {
  defaultMessage: 'Infrastructure'
});
exports.infraAccordionTitle = infraAccordionTitle;
const cloudAccordionTitle = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.accordion.title.cloud', {
  defaultMessage: 'Cloud'
});
exports.cloudAccordionTitle = cloudAccordionTitle;
const otherAccordionTitle = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.accordion.title.other', {
  defaultMessage: 'Other'
});
exports.otherAccordionTitle = otherAccordionTitle;
const flyoutOrchestratorClusterNameLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.orchestratorClusterName', {
  defaultMessage: 'Orchestrator cluster Name'
});
exports.flyoutOrchestratorClusterNameLabel = flyoutOrchestratorClusterNameLabel;
const flyoutOrchestratorResourceIdLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.orchestratorResourceId', {
  defaultMessage: 'Orchestrator resource ID'
});
exports.flyoutOrchestratorResourceIdLabel = flyoutOrchestratorResourceIdLabel;
const flyoutCloudProviderLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.cloudProvider', {
  defaultMessage: 'Cloud provider'
});
exports.flyoutCloudProviderLabel = flyoutCloudProviderLabel;
const flyoutCloudRegionLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.cloudRegion', {
  defaultMessage: 'Cloud region'
});
exports.flyoutCloudRegionLabel = flyoutCloudRegionLabel;
const flyoutCloudAvailabilityZoneLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.cloudAvailabilityZone', {
  defaultMessage: 'Cloud availability zone'
});
exports.flyoutCloudAvailabilityZoneLabel = flyoutCloudAvailabilityZoneLabel;
const flyoutCloudProjectIdLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.cloudProjectId', {
  defaultMessage: 'Cloud project ID'
});
exports.flyoutCloudProjectIdLabel = flyoutCloudProjectIdLabel;
const flyoutCloudInstanceIdLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.cloudInstanceId', {
  defaultMessage: 'Cloud instance ID'
});
exports.flyoutCloudInstanceIdLabel = flyoutCloudInstanceIdLabel;
const flyoutLogPathFileLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.logPathFile', {
  defaultMessage: 'Log path file'
});
exports.flyoutLogPathFileLabel = flyoutLogPathFileLabel;
const flyoutNamespaceLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.namespace', {
  defaultMessage: 'Namespace'
});
exports.flyoutNamespaceLabel = flyoutNamespaceLabel;
const flyoutDatasetLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.dataset', {
  defaultMessage: 'Dataset'
});
exports.flyoutDatasetLabel = flyoutDatasetLabel;
const flyoutShipperLabel = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.label.shipper', {
  defaultMessage: 'Shipper'
});
exports.flyoutShipperLabel = flyoutShipperLabel;
const flyoutHoverActionFilterForText = text => _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.value.hover.filterFor', {
  defaultMessage: 'Filter for this {value}',
  values: {
    value: text
  }
});
exports.flyoutHoverActionFilterForText = flyoutHoverActionFilterForText;
const flyoutHoverActionFilterOutText = text => _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.value.hover.filterOut', {
  defaultMessage: 'Filter out this {value}',
  values: {
    value: text
  }
});
exports.flyoutHoverActionFilterOutText = flyoutHoverActionFilterOutText;
const flyoutHoverActionFilterForFieldPresentText = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.value.hover.filterForFieldPresent', {
  defaultMessage: 'Filter for field present'
});
exports.flyoutHoverActionFilterForFieldPresentText = flyoutHoverActionFilterForFieldPresentText;
const flyoutHoverActionToggleColumnText = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.value.hover.toggleColumn', {
  defaultMessage: 'Toggle column in table'
});
exports.flyoutHoverActionToggleColumnText = flyoutHoverActionToggleColumnText;
const flyoutHoverActionCopyToClipboardText = _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.value.hover.copyToClipboard', {
  defaultMessage: 'Copy to clipboard'
});
exports.flyoutHoverActionCopyToClipboardText = flyoutHoverActionCopyToClipboardText;
const flyoutAccordionShowMoreText = count => _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.section.showMore', {
  defaultMessage: '+ {hiddenCount} more',
  values: {
    hiddenCount: count
  }
});
exports.flyoutAccordionShowMoreText = flyoutAccordionShowMoreText;