"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverActionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HoverActionPopover = ({
  children,
  actions,
  title
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const leaveTimer = (0, _react.useRef)(null);

  // The timeout hack is required because we are using a Popover which ideally should be used with a mouseclick,
  // but we are using it as a Tooltip. Which means we now need to manually handle the open and close
  // state using the mouse hover events. This cause the popover to close even before the user could
  // navigate actions inside it. Hence, to prevent this, we need this hack
  const onMouseEnter = () => {
    if (leaveTimer.current) {
      clearTimeout(leaveTimer.current);
    }
    setIsPopoverOpen(true);
  };
  const onMouseLeave = () => {
    leaveTimer.current = setTimeout(() => setIsPopoverOpen(false), 100);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: children,
    isOpen: isPopoverOpen,
    anchorPosition: "upCenter",
    panelPaddingSize: "s",
    panelStyle: {
      minWidth: '24px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    className: "eui-textBreakWord",
    css: {
      maxWidth: '200px'
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, actions.map(action => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: action.tooltipContent,
    key: action.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: action.iconType,
    "aria-label": action.tooltipContent,
    onClick: () => action.onClick()
  }))))));
};
exports.HoverActionPopover = HoverActionPopover;