"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHighlights = FlyoutHighlights;
var _react = _interopRequireDefault(require("react"));
var _customIcons = require("@kbn/custom-icons");
var _lib = require("react-use/lib");
var _lodash = require("lodash");
var constants = _interopRequireWildcard(require("../../../common/constants"));
var _highlight_field = require("./sub_components/highlight_field");
var _translations = require("./translations");
var _highlight_section = require("./sub_components/highlight_section");
var _use_discover_action = require("../../hooks/use_discover_action");
var _highlight_container = require("./sub_components/highlight_container");
var _use_flyouot_column_width = require("../../hooks/use_flyouot_column_width");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutHighlights({
  formattedDoc,
  flattenedDoc,
  actions
}) {
  var _flattenedDoc$constan, _flattenedDoc$constan2;
  const [ref, dimensions] = (0, _lib.useMeasure)();
  const {
    columns,
    fieldWidth
  } = (0, _use_flyouot_column_width.useFlyoutColumnWidth)(dimensions.width);
  return /*#__PURE__*/_react.default.createElement(_use_discover_action.DiscoverActionsProvider, {
    value: actions
  }, /*#__PURE__*/_react.default.createElement(_highlight_container.HighlightContainer, {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: _translations.serviceAccordionTitle,
    columns: columns
  }, formattedDoc[constants.SERVICE_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutService",
    field: constants.SERVICE_NAME_FIELD,
    formattedValue: formattedDoc[constants.SERVICE_NAME_FIELD],
    icon: /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
      agentName: (0, _lodash.first)((_flattenedDoc$constan = flattenedDoc[constants.AGENT_NAME_FIELD]) !== null && _flattenedDoc$constan !== void 0 ? _flattenedDoc$constan : [])
    }),
    label: _translations.flyoutServiceLabel,
    value: flattenedDoc[constants.SERVICE_NAME_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.TRACE_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutTrace",
    field: constants.TRACE_ID_FIELD,
    formattedValue: formattedDoc[constants.TRACE_ID_FIELD],
    label: _translations.flyoutTraceLabel,
    value: flattenedDoc[constants.TRACE_ID_FIELD],
    width: fieldWidth
  })), /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: _translations.infraAccordionTitle,
    columns: columns
  }, formattedDoc[constants.HOST_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutHostName",
    field: constants.HOST_NAME_FIELD,
    formattedValue: formattedDoc[constants.HOST_NAME_FIELD],
    label: _translations.flyoutHostNameLabel,
    value: flattenedDoc[constants.HOST_NAME_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.ORCHESTRATOR_CLUSTER_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutClusterName",
    field: constants.ORCHESTRATOR_CLUSTER_NAME_FIELD,
    formattedValue: formattedDoc[constants.ORCHESTRATOR_CLUSTER_NAME_FIELD],
    label: _translations.flyoutOrchestratorClusterNameLabel,
    value: flattenedDoc[constants.ORCHESTRATOR_CLUSTER_NAME_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.ORCHESTRATOR_RESOURCE_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutResourceId",
    field: constants.ORCHESTRATOR_RESOURCE_ID_FIELD,
    formattedValue: formattedDoc[constants.ORCHESTRATOR_RESOURCE_ID_FIELD],
    label: _translations.flyoutOrchestratorResourceIdLabel,
    value: flattenedDoc[constants.ORCHESTRATOR_RESOURCE_ID_FIELD],
    width: fieldWidth
  })), /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: _translations.cloudAccordionTitle,
    columns: columns
  }, formattedDoc[constants.CLOUD_PROVIDER_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutCloudProvider",
    field: constants.CLOUD_PROVIDER_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_PROVIDER_FIELD],
    icon: /*#__PURE__*/_react.default.createElement(_customIcons.CloudProviderIcon, {
      cloudProvider: (0, _lodash.first)((_flattenedDoc$constan2 = flattenedDoc[constants.CLOUD_PROVIDER_FIELD]) !== null && _flattenedDoc$constan2 !== void 0 ? _flattenedDoc$constan2 : [])
    }),
    label: _translations.flyoutCloudProviderLabel,
    value: flattenedDoc[constants.CLOUD_PROVIDER_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.CLOUD_REGION_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutCloudRegion",
    field: constants.CLOUD_REGION_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_REGION_FIELD],
    label: _translations.flyoutCloudRegionLabel,
    value: flattenedDoc[constants.CLOUD_REGION_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.CLOUD_AVAILABILITY_ZONE_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutCloudAz",
    field: constants.CLOUD_AVAILABILITY_ZONE_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_AVAILABILITY_ZONE_FIELD],
    label: _translations.flyoutCloudAvailabilityZoneLabel,
    value: flattenedDoc[constants.CLOUD_AVAILABILITY_ZONE_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.CLOUD_PROJECT_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutCloudProjectId",
    field: constants.CLOUD_PROJECT_ID_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_PROJECT_ID_FIELD],
    label: _translations.flyoutCloudProjectIdLabel,
    value: flattenedDoc[constants.CLOUD_PROJECT_ID_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.CLOUD_INSTANCE_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutCloudInstanceId",
    field: constants.CLOUD_INSTANCE_ID_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_INSTANCE_ID_FIELD],
    label: _translations.flyoutCloudInstanceIdLabel,
    value: flattenedDoc[constants.CLOUD_INSTANCE_ID_FIELD],
    width: fieldWidth
  })), /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: _translations.otherAccordionTitle,
    columns: columns
  }, formattedDoc[constants.LOG_FILE_PATH_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutLogPathFile",
    field: constants.LOG_FILE_PATH_FIELD,
    formattedValue: formattedDoc[constants.LOG_FILE_PATH_FIELD],
    label: _translations.flyoutLogPathFileLabel,
    value: flattenedDoc[constants.LOG_FILE_PATH_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.DATASTREAM_NAMESPACE_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutNamespace",
    field: constants.DATASTREAM_NAMESPACE_FIELD,
    formattedValue: formattedDoc[constants.DATASTREAM_NAMESPACE_FIELD],
    label: _translations.flyoutNamespaceLabel,
    value: flattenedDoc[constants.DATASTREAM_NAMESPACE_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.DATASTREAM_DATASET_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutDataset",
    field: constants.DATASTREAM_DATASET_FIELD,
    formattedValue: formattedDoc[constants.DATASTREAM_DATASET_FIELD],
    label: _translations.flyoutDatasetLabel,
    value: flattenedDoc[constants.DATASTREAM_DATASET_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.AGENT_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logExplorerFlyoutLogShipper",
    field: constants.AGENT_NAME_FIELD,
    formattedValue: formattedDoc[constants.AGENT_NAME_FIELD],
    label: _translations.flyoutShipperLabel,
    value: flattenedDoc[constants.AGENT_NAME_FIELD],
    width: fieldWidth
  }))));
}