"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BuilderLogicButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiButton = (0, _styledComponents.default)(_eui.EuiButton)`
  min-width: 95px;
`;
const BuilderLogicButtons = ({
  isAndDisabled = false,
  isNested,
  isNestedDisabled = true,
  isOrDisabled = false,
  isOrHidden = false,
  showNestedButton = false,
  onAddClickWhenNested,
  onAndClicked,
  onNestedClicked,
  onOrClicked
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(MyEuiButton, {
  size: "s",
  iconType: "plusInCircle",
  onClick: isNested ? onAddClickWhenNested : onAndClicked,
  "data-test-subj": "exceptionsAndButton",
  isDisabled: isAndDisabled
}, i18n.AND)), !isOrHidden && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(MyEuiButton, {
  fill: true,
  size: "s",
  iconType: "plusInCircle",
  onClick: onOrClicked,
  isDisabled: isOrDisabled,
  "data-test-subj": "exceptionsOrButton"
}, i18n.OR)), showNestedButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  size: "s",
  iconType: "nested",
  onClick: isNested ? onAndClicked : onNestedClicked,
  isDisabled: isNestedDisabled,
  "data-test-subj": "exceptionsNestedButton"
}, isNested ? i18n.ADD_NON_NESTED_DESCRIPTION : i18n.ADD_NESTED_DESCRIPTION)));
exports.BuilderLogicButtons = BuilderLogicButtons;