"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.linksSavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const linksSavedObjectType = {
  name: _common.CONTENT_ID,
  indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  management: {
    icon: _common.APP_ICON,
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      links: {
        dynamic: false,
        properties: {}
      }
    }
  },
  migrations: () => {
    return {};
  }
};
exports.linksSavedObjectType = linksSavedObjectType;