"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksEmbeddable = exports.LinksContext = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("../../common");
var _links_component = require("../components/links_component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinksContext = /*#__PURE__*/(0, _react.createContext)(null);
exports.LinksContext = LinksContext;
class LinksEmbeddable extends _public.Embeddable {
  constructor(config, initialInput, attributeService, parent) {
    super(initialInput, {
      editable: config.editable,
      editableWithExplicitInput: true
    }, parent);
    (0, _defineProperty2.default)(this, "type", _common.CONTENT_ID);
    (0, _defineProperty2.default)(this, "deferEmbeddableLoad", true);
    (0, _defineProperty2.default)(this, "domNode", void 0);
    (0, _defineProperty2.default)(this, "isDestroyed", void 0);
    (0, _defineProperty2.default)(this, "subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "attributes", void 0);
    (0, _defineProperty2.default)(this, "attributes$", new _rxjs.Subject());
    this.attributeService = attributeService;
    this.initializeSavedLinks().then(() => this.setInitializationFinished()).catch(e => this.onFatalError(e));

    // By-value panels should update the links attributes when input changes
    this.subscriptions.add(this.getInput$().pipe((0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default), (0, _rxjs.skip)(1), (0, _rxjs.switchMap)(async () => await this.initializeSavedLinks())).subscribe());

    // Keep attributes in sync with subject value so it can be used in output
    this.subscriptions.add(this.attributes$.pipe((0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default)).subscribe(attributes => {
      this.attributes = attributes;
    }));
  }
  async initializeSavedLinks() {
    const {
      attributes
    } = await this.attributeService.unwrapAttributes(this.getInput());
    this.attributes$.next(attributes);
    await this.initializeOutput();
  }
  async initializeOutput() {
    var _this$attributes, _this$attributes2, _this$attributes3, _this$attributes4;
    const {
      title,
      description
    } = this.getInput();
    this.updateOutput({
      defaultTitle: (_this$attributes = this.attributes) === null || _this$attributes === void 0 ? void 0 : _this$attributes.title,
      defaultDescription: (_this$attributes2 = this.attributes) === null || _this$attributes2 === void 0 ? void 0 : _this$attributes2.description,
      title: title !== null && title !== void 0 ? title : (_this$attributes3 = this.attributes) === null || _this$attributes3 === void 0 ? void 0 : _this$attributes3.title,
      description: description !== null && description !== void 0 ? description : (_this$attributes4 = this.attributes) === null || _this$attributes4 === void 0 ? void 0 : _this$attributes4.description
    });
  }
  onRender() {
    this.renderComplete.dispatchComplete();
  }
  onLoading() {
    this.renderComplete.dispatchInProgress();
  }
  inputIsRefType(input) {
    return this.attributeService.inputIsRefType(input);
  }
  async getInputAsRefType() {
    return this.attributeService.getInputAsRefType(this.getExplicitInput(), {
      showSaveModal: true,
      saveModalTitle: this.getTitle()
    });
  }
  async getInputAsValueType() {
    return this.attributeService.getInputAsValueType(this.getExplicitInput());
  }
  async reload() {
    if (this.isDestroyed) return;
    // By-reference embeddable panels are reloaded when changed, so update the attributes
    this.initializeSavedLinks();
    if (this.domNode) {
      this.render(this.domNode);
    }
  }
  destroy() {
    this.isDestroyed = true;
    super.destroy();
    this.subscriptions.unsubscribe();
    if (this.domNode) {
      (0, _reactDom.unmountComponentAtNode)(this.domNode);
    }
  }
  render(domNode) {
    this.domNode = domNode;
    if (this.isDestroyed) return;
    super.render(domNode);
    this.domNode.setAttribute('data-shared-item', '');
    return /*#__PURE__*/_react.default.createElement(LinksContext.Provider, {
      value: this
    }, /*#__PURE__*/_react.default.createElement(_links_component.LinksComponent, null));
  }
}
exports.LinksEmbeddable = LinksEmbeddable;