"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalLinkDestinationPicker = void 0;
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _external_link_strings = require("./external_link_strings");
var _external_link_tools = require("./external_link_tools");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ExternalLinkDestinationPicker = ({
  onDestinationPicked,
  setDestinationError,
  initialSelection,
  onUnmount,
  ...other
}) => {
  const [validUrl, setValidUrl] = (0, _react.useState)(true);
  const [currentUrl, setCurrentUrl] = (0, _react.useState)(initialSelection !== null && initialSelection !== void 0 ? initialSelection : '');
  (0, _useMount.default)(() => {
    if (initialSelection) {
      const {
        valid,
        message
      } = (0, _external_link_tools.validateUrl)(initialSelection);
      if (!valid) {
        setValidUrl(false);
        setDestinationError(message);
        onDestinationPicked(undefined); // prevent re-saving an invalid link
      } else {
        onDestinationPicked(initialSelection);
      }
    }
  });
  (0, _useUnmount.default)(() => {
    /** Save the current selection so we can re-populate it if we switch back to this link editor */
    onUnmount(currentUrl);
  });

  /* {...other} is needed so all inner elements are treated as part of the form */
  return /*#__PURE__*/_react.default.createElement("div", other, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: currentUrl,
    placeholder: _external_link_strings.ExternalLinkStrings.getPlaceholder(),
    isInvalid: !validUrl,
    onChange: event => {
      const url = event.target.value;
      setCurrentUrl(url);
      if (url === '') {
        /* no need to validate the empty string - not an error, but also not a valid destination */
        setValidUrl(true);
        onDestinationPicked(undefined);
        setDestinationError(undefined);
        return;
      }
      const {
        valid,
        message
      } = (0, _external_link_tools.validateUrl)(url);
      setValidUrl(valid);
      if (valid) {
        onDestinationPicked(url);
        setDestinationError(undefined);
      } else {
        onDestinationPicked(undefined);
        setDestinationError(message);
      }
    },
    "data-test-subj": "links--linkEditor--externalLink--input"
  }));
};
exports.ExternalLinkDestinationPicker = ExternalLinkDestinationPicker;