"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalLinkComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/ui-actions-enhanced-plugin/public");
var _content_management = require("../../../common/content_management");
var _kibana_services = require("../../services/kibana_services");
var _external_link_tools = require("./external_link_tools");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ExternalLinkComponent = ({
  link,
  layout,
  onRender
}) => {
  const [error, setError] = (0, _react.useState)();
  (0, _useMount.default)(() => {
    onRender();
  });
  const linkOptions = (0, _react.useMemo)(() => {
    return {
      ..._public.DEFAULT_URL_DRILLDOWN_OPTIONS,
      ...link.options
    };
  }, [link.options]);
  const isValidUrl = (0, _react.useMemo)(() => {
    if (!link.destination) return false;
    const {
      valid,
      message
    } = (0, _external_link_tools.validateUrl)(link.destination);
    if (!valid) setError(message);
    return valid;
  }, [link.destination]);
  const destination = (0, _react.useMemo)(() => {
    return link.destination && linkOptions.encodeUrl ? encodeURI(link.destination) : link.destination;
  }, [linkOptions, link.destination]);
  const id = `externalLink--${link.id}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    size: "s",
    color: "text",
    isDisabled: !link.destination || !isValidUrl,
    className: 'linksPanelLink',
    showToolTip: !isValidUrl,
    toolTipProps: {
      content: error,
      position: layout === _content_management.LINKS_VERTICAL_LAYOUT ? 'right' : 'bottom',
      repositionOnScroll: true,
      delay: 'long',
      'data-test-subj': `${id}--tooltip`
    },
    iconType: error ? 'warning' : undefined,
    id: id,
    label: link.label || link.destination,
    "data-test-subj": error ? `${id}--error` : `${id}`,
    href: destination,
    onClick: async event => {
      if (!destination) return;
      _kibana_services.trackUiMetric === null || _kibana_services.trackUiMetric === void 0 ? void 0 : (0, _kibana_services.trackUiMetric)(_analytics.METRIC_TYPE.CLICK, `${_content_management.EXTERNAL_LINK_TYPE}:click`);

      /** Only use `navigateToUrl` if we **aren't** opening in a new window/tab; otherwise, just use default href handling */
      const modifiedClick = event.ctrlKey || event.metaKey || event.shiftKey;
      if (!modifiedClick) {
        event.preventDefault();
        if (linkOptions.openInNewTab) {
          window.open(destination, '_blank');
        } else {
          await _kibana_services.coreServices.application.navigateToUrl(destination);
        }
      }
    }
  });
};
exports.ExternalLinkComponent = ExternalLinkComponent;