"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _ = require(".");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const baseLinkSchema = {
  id: _configSchema.schema.string(),
  label: _configSchema.schema.maybe(_configSchema.schema.string()),
  order: _configSchema.schema.number()
};
const dashboardLinkSchema = _configSchema.schema.object({
  ...baseLinkSchema,
  destinationRefName: _configSchema.schema.string(),
  type: _configSchema.schema.literal(_.DASHBOARD_LINK_TYPE),
  options: _configSchema.schema.maybe(_configSchema.schema.object({
    openInNewTab: _configSchema.schema.boolean(),
    useCurrentFilters: _configSchema.schema.boolean(),
    useCurrentDateRange: _configSchema.schema.boolean()
  }, {
    unknowns: 'forbid'
  }))
});
const externalLinkSchema = _configSchema.schema.object({
  ...baseLinkSchema,
  type: _configSchema.schema.literal(_.EXTERNAL_LINK_TYPE),
  destination: _configSchema.schema.string(),
  options: _configSchema.schema.maybe(_configSchema.schema.object({
    openInNewTab: _configSchema.schema.boolean(),
    encodeUrl: _configSchema.schema.boolean()
  }, {
    unknowns: 'forbid'
  }))
});
const linksAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  links: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([dashboardLinkSchema, externalLinkSchema])),
  layout: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.LINKS_HORIZONTAL_LAYOUT), _configSchema.schema.literal(_constants.LINKS_VERTICAL_LAYOUT)]))
}, {
  unknowns: 'forbid'
});
const linksSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(linksAttributesSchema);
const searchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const linksCreateOptionsSchema = _configSchema.schema.object({
  references: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.references),
  overwrite: _contentManagementUtils.createOptionsSchemas.overwrite
});
const linksUpdateOptionsSchema = _configSchema.schema.object({
  references: _contentManagementUtils.updateOptionsSchema.references
});

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(linksSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: linksCreateOptionsSchema
      },
      data: {
        schema: linksAttributesSchema
      }
    },
    out: {
      result: {
        schema: (0, _contentManagementUtils.createResultSchema)(linksSavedObjectSchema)
      }
    }
  },
  update: {
    in: {
      options: {
        schema: linksUpdateOptionsSchema // same schema as "create"
      },

      data: {
        schema: linksAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: searchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: linksSavedObjectSchema
      }
    }
  }
};
exports.serviceDefinition = serviceDefinition;