"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsDimensionEditor = TagsDimensionEditor;
var _react = _interopRequireWildcard(require("react"));
var _coloring = require("@kbn/coloring");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _shared_components = require("../../shared_components");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TagsDimensionEditor({
  state,
  frame,
  setState,
  panelRef,
  isDarkMode,
  paletteService,
  isInlineEditing
}) {
  var _frame$activeData, _table$rows, _state$colorMapping;
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    value: state,
    onChange: setState
  });
  const [isPaletteOpen, setIsPaletteOpen] = (0, _react.useState)(false);
  const [useNewColorMapping, setUseNewColorMapping] = (0, _react.useState)(state.colorMapping ? true : false);
  const colors = (0, _coloring.getColorsFromMapping)(isDarkMode, state.colorMapping);
  const table = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId];
  const splitCategories = (0, _chartExpressionsCommon.getColorCategories)((_table$rows = table === null || table === void 0 ? void 0 : table.rows) !== null && _table$rows !== void 0 ? _table$rows : [], state.tagAccessor);
  const setColorMapping = (0, _react.useCallback)(colorMapping => {
    setLocalState({
      ...localState,
      colorMapping
    });
  }, [localState, setLocalState]);
  const setPalette = (0, _react.useCallback)(palette => {
    setLocalState({
      ...localState,
      palette,
      colorMapping: undefined
    });
  }, [localState, setLocalState]);
  const canUseColorMapping = state.colorMapping;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingSectionlabel', {
      defaultMessage: 'Color mapping'
    }),
    style: {
      alignItems: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    className: "lnsDynamicColoringClickable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
    "data-test-subj": "lns_dynamicColoring_edit",
    palette: colors,
    type: 'fixed',
    onClick: () => {
      setIsPaletteOpen(!isPaletteOpen);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "lns_colorEditing_trigger",
    "aria-label": _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingButton', {
      defaultMessage: 'Edit palette'
    }),
    iconType: "controlsHorizontal",
    onClick: () => {
      setIsPaletteOpen(!isPaletteOpen);
    },
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
    siblingRef: panelRef,
    isOpen: isPaletteOpen,
    handleClose: () => setIsPaletteOpen(!isPaletteOpen),
    title: useNewColorMapping ? _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingTitle', {
      defaultMessage: 'Edit colors by term mapping'
    }) : _i18n.i18n.translate('xpack.lens.colorMapping.editColorsTitle', {
      defaultMessage: 'Edit colors'
    }),
    isInlineEditing: isInlineEditing
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsPalettePanel__section lnsPalettePanel__section--shaded lnsIndexPatternDimensionEditor--padded"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.lens.colorMapping.tryLabel', {
      defaultMessage: 'Use the new Color Mapping feature'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.lens.colorMapping.techPreviewLabel', {
      defaultMessage: 'Tech preview'
    })))),
    "data-test-subj": "lns_colorMappingOrLegacyPalette_switch",
    compressed: true,
    checked: useNewColorMapping,
    onChange: ({
      target: {
        checked
      }
    }) => {
      (0, _lens_ui_telemetry.trackUiCounterEvents)(`color_mapping_switch_${checked ? 'enabled' : 'disabled'}`);
      setColorMapping(checked ? {
        ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
      } : undefined);
      setUseNewColorMapping(checked);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, canUseColorMapping || useNewColorMapping ? /*#__PURE__*/_react.default.createElement(_coloring.CategoricalColorMapping, {
    isDarkMode: isDarkMode,
    model: (_state$colorMapping = state.colorMapping) !== null && _state$colorMapping !== void 0 ? _state$colorMapping : {
      ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
    },
    onModelUpdate: model => setColorMapping(model),
    palettes: _coloring.AVAILABLE_PALETTES,
    data: {
      type: 'categories',
      categories: splitCategories
    },
    specialTokens: _coloring.SPECIAL_TOKENS_STRING_CONVERTION
  }) : /*#__PURE__*/_react.default.createElement(_shared_components.PalettePicker, {
    palettes: paletteService,
    activePalette: state.palette,
    setPalette: newPalette => {
      setPalette(newPalette);
    }
  }))))))));
}