"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowHeightSettings = RowHeightSettings;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const idPrefix = (0, _eui.htmlIdGenerator)()();
function RowHeightSettings(props) {
  const {
    label,
    rowHeight,
    rowHeightLines,
    onChangeRowHeight,
    onChangeRowHeightLines,
    maxRowHeight
  } = props;
  const rowHeightModeOptions = [{
    id: `${idPrefix}single`,
    label: _i18n.i18n.translate('xpack.lens.table.rowHeight.single', {
      defaultMessage: 'Single'
    }),
    'data-test-subj': 'lnsDatatable_rowHeight_single'
  }, {
    id: `${idPrefix}auto`,
    label: _i18n.i18n.translate('xpack.lens.table.rowHeight.auto', {
      defaultMessage: 'Auto fit'
    }),
    'data-test-subj': 'lnsDatatable_rowHeight_auto'
  }, {
    id: `${idPrefix}custom`,
    label: _i18n.i18n.translate('xpack.lens.table.rowHeight.custom', {
      defaultMessage: 'Custom'
    }),
    'data-test-subj': 'lnsDatatable_rowHeight_custom'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    display: "columnCompressed",
    "data-test-subj": props['data-test-subj']
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: label,
    name: "legendLocation",
    buttonSize: "compressed",
    options: rowHeightModeOptions,
    idSelected: `${idPrefix}${rowHeight !== null && rowHeight !== void 0 ? rowHeight : 'single'}`,
    onChange: optionId => {
      const newMode = optionId.replace(idPrefix, '');
      onChangeRowHeight(newMode);
    }
  }), rowHeight === 'custom' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    compressed: true,
    fullWidth: true,
    showInput: true,
    min: 1,
    max: maxRowHeight !== null && maxRowHeight !== void 0 ? maxRowHeight : 20,
    step: 1,
    value: rowHeightLines !== null && rowHeightLines !== void 0 ? rowHeightLines : 2,
    onChange: e => {
      const lineCount = Number(e.currentTarget.value);
      onChangeRowHeightLines(lineCount);
    },
    "data-test-subj": "lens-table-row-height-lineCountNumber"
  })) : null)));
}