"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrependWidthProvider = exports.PrependWidthContext = exports.Prepend = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrependWidthContext = /*#__PURE__*/(0, _react.createContext)({
  minWidth: 0,
  onResize: () => {}
});
exports.PrependWidthContext = PrependWidthContext;
const PrependWidthProvider = ({
  children
}) => {
  const [minPrependWidth, setMinPrependWidth] = (0, _react.useState)(0);
  const prependResizeObserver = ({
    width
  }) => {
    if (width > minPrependWidth) {
      setMinPrependWidth(width);
    }
  };
  return /*#__PURE__*/_react.default.createElement(PrependWidthContext.Provider, {
    value: {
      minWidth: minPrependWidth,
      onResize: prependResizeObserver
    }
  }, children);
};
exports.PrependWidthProvider = PrependWidthProvider;
const Prepend = ({
  children
}) => {
  const {
    minWidth,
    onResize
  } = (0, _react.useContext)(PrependWidthContext);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const paddingAffordance = parseInt(euiTheme.size.m, 10) * 2;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    css: {
      minWidth: Math.round(minWidth) + paddingAffordance
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement("span", {
    ref: resizeRef
  }, children)));
};
exports.Prepend = Prepend;