"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormBasedDataPanel = FormBasedDataPanel;
exports.MemoizedDataPanel = exports.InnerFormBasedDataPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./datapanel.scss");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/ui-actions-plugin/public");
var _unifiedFieldList = require("@kbn/unified-field-list");
var _field_item = require("../common/field_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const supportedFieldTypes = new Set(['string', 'number', 'boolean', 'date', 'ip', 'number_range', 'date_range', 'ip_range', 'histogram', 'document', 'geo_point', 'geo_shape', 'murmur3']);
function onSupportedFieldFilter(field) {
  return supportedFieldTypes.has(field.type);
}
function FormBasedDataPanel({
  state,
  core,
  data,
  dataViews,
  fieldFormats,
  query,
  filters,
  dateRange,
  charts,
  indexPatternFieldEditor,
  showNoDataPopover,
  dropOntoWorkspace,
  hasSuggestionForField,
  uiActions,
  indexPatternService,
  frame,
  onIndexPatternRefresh,
  usedIndexPatterns,
  layerFields
}) {
  const {
    indexPatterns,
    indexPatternRefs
  } = frame.dataViews;
  const {
    currentIndexPatternId
  } = state;
  const activeIndexPatterns = (0, _react.useMemo)(() => {
    return (0, _lodash.uniq)((usedIndexPatterns !== null && usedIndexPatterns !== void 0 ? usedIndexPatterns : Object.values(state.layers).map(({
      indexPatternId
    }) => indexPatternId)).concat(currentIndexPatternId)).filter(id => !!indexPatterns[id]).sort().map(id => indexPatterns[id]);
  }, [usedIndexPatterns, indexPatterns, state.layers, currentIndexPatternId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.keys(indexPatterns).length === 0 && indexPatternRefs.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    className: "lnsInnerIndexPatternDataPanel",
    direction: "column",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "indexPattern-no-indexpatterns",
    title: _i18n.i18n.translate('xpack.lens.indexPattern.noDataViewsLabel', {
      defaultMessage: 'No data views'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.noDataViewDescription",
    defaultMessage: "Please create a data view or switch to another data source"
  }))))) : /*#__PURE__*/_react.default.createElement(MemoizedDataPanel, {
    currentIndexPatternId: currentIndexPatternId,
    query: query,
    dateRange: dateRange,
    filters: filters,
    core: core,
    data: data,
    dataViews: dataViews,
    fieldFormats: fieldFormats,
    charts: charts,
    indexPatternFieldEditor: indexPatternFieldEditor,
    dropOntoWorkspace: dropOntoWorkspace,
    hasSuggestionForField: hasSuggestionForField,
    uiActions: uiActions,
    indexPatternService: indexPatternService,
    onIndexPatternRefresh: onIndexPatternRefresh,
    frame: frame,
    layerFields: layerFields,
    showNoDataPopover: showNoDataPopover,
    activeIndexPatterns: activeIndexPatterns
  }));
}
const InnerFormBasedDataPanel = function InnerFormBasedDataPanel({
  currentIndexPatternId,
  query,
  dateRange,
  filters,
  core,
  data,
  dataViews,
  indexPatternFieldEditor,
  dropOntoWorkspace,
  hasSuggestionForField,
  uiActions,
  indexPatternService,
  frame,
  onIndexPatternRefresh,
  layerFields,
  showNoDataPopover,
  activeIndexPatterns
}) {
  const {
    indexPatterns
  } = frame.dataViews;
  const currentIndexPattern = indexPatterns[currentIndexPatternId];
  const {
    refetchFieldsExistenceInfo,
    isProcessing
  } = (0, _unifiedFieldList.useExistingFieldsFetcher)({
    dataViews: activeIndexPatterns,
    query,
    filters,
    fromDate: dateRange.fromDate,
    toDate: dateRange.toDate,
    services: {
      data,
      dataViews,
      core
    },
    onNoData: dataViewId => {
      if (dataViewId === currentIndexPatternId) {
        showNoDataPopover();
      }
    }
  });
  const visualizeGeoFieldTrigger = uiActions.getTrigger(_public.VISUALIZE_GEO_FIELD_TRIGGER);
  const allFields = (0, _react.useMemo)(() => {
    if (!currentIndexPattern) return [];
    return visualizeGeoFieldTrigger ? currentIndexPattern.fields : currentIndexPattern.fields.filter(({
      type
    }) => type !== 'geo_point' && type !== 'geo_shape');
  }, [currentIndexPattern, visualizeGeoFieldTrigger]);
  const editPermission = indexPatternFieldEditor.userPermissions.editIndexPattern() || !currentIndexPattern.isPersisted;
  const onSelectedFieldFilter = (0, _react.useCallback)(field => {
    return Boolean(layerFields === null || layerFields === void 0 ? void 0 : layerFields.includes(field.name));
  }, [layerFields]);
  const onOverrideFieldGroupDetails = (0, _react.useCallback)(groupName => {
    if (groupName === _unifiedFieldList.FieldsGroupNames.AvailableFields) {
      return {
        helpText: _i18n.i18n.translate('xpack.lens.indexPattern.allFieldsLabelHelp', {
          defaultMessage: 'Drag and drop available fields to the workspace and create visualizations. To change the available fields, select a different data view, edit your queries, or use a different time range. Some field types cannot be visualized in Lens, including full text and geographic fields.'
        })
      };
    }
  }, []);
  const {
    fieldListFiltersProps,
    fieldListGroupedProps
  } = (0, _unifiedFieldList.useGroupedFields)({
    dataViewId: currentIndexPatternId,
    allFields,
    services: {
      dataViews,
      core
    },
    isAffectedByGlobalFilter: Boolean(filters.length),
    onSupportedFieldFilter,
    onSelectedFieldFilter,
    onOverrideFieldGroupDetails
  });
  const closeFieldEditor = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editor when unmounting
      if (closeFieldEditor.current) {
        closeFieldEditor.current();
      }
    };
  }, []);
  const refreshFieldList = (0, _react.useCallback)(async () => {
    if (currentIndexPattern) {
      const newlyMappedIndexPattern = await indexPatternService.loadIndexPatterns({
        patterns: [currentIndexPattern.id],
        cache: {},
        onIndexPatternRefresh
      });
      indexPatternService.updateDataViewsState({
        indexPatterns: {
          ...frame.dataViews.indexPatterns,
          [currentIndexPattern.id]: newlyMappedIndexPattern[currentIndexPattern.id]
        }
      });
    }
    // start a new session so all charts are refreshed
    data.search.session.start();
  }, [indexPatternService, currentIndexPattern, onIndexPatternRefresh, frame.dataViews.indexPatterns, data.search.session]);
  const editField = (0, _react.useMemo)(() => editPermission ? async (fieldName, uiAction = 'edit') => {
    const indexPatternInstance = await dataViews.get(currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id);
    closeFieldEditor.current = indexPatternFieldEditor.openEditor({
      ctx: {
        dataView: indexPatternInstance
      },
      fieldName,
      onSave: () => {
        if (indexPatternInstance.isPersisted()) {
          refreshFieldList();
          refetchFieldsExistenceInfo(indexPatternInstance.id);
        } else {
          indexPatternService.replaceDataViewId(indexPatternInstance);
        }
      }
    });
  } : undefined, [editPermission, dataViews, currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id, indexPatternFieldEditor, refreshFieldList, indexPatternService, refetchFieldsExistenceInfo]);
  const removeField = (0, _react.useMemo)(() => editPermission ? async fieldName => {
    const indexPatternInstance = await dataViews.get(currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id);
    closeFieldEditor.current = indexPatternFieldEditor.openDeleteModal({
      ctx: {
        dataView: indexPatternInstance
      },
      fieldName,
      onDelete: () => {
        if (indexPatternInstance.isPersisted()) {
          refreshFieldList();
          refetchFieldsExistenceInfo(indexPatternInstance.id);
        } else {
          indexPatternService.replaceDataViewId(indexPatternInstance);
        }
      }
    });
  } : undefined, [currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id, dataViews, editPermission, indexPatternFieldEditor, indexPatternService, refreshFieldList, refetchFieldsExistenceInfo]);
  const renderFieldItem = (0, _react.useCallback)(({
    field,
    itemIndex,
    groupIndex,
    groupName,
    hideDetails,
    fieldSearchHighlight
  }) => /*#__PURE__*/_react.default.createElement(_field_item.FieldItem, {
    field: field,
    exists: groupName !== _unifiedFieldList.FieldsGroupNames.EmptyFields,
    hideDetails: hideDetails || field.type === 'document',
    itemIndex: itemIndex,
    groupIndex: groupIndex,
    dropOntoWorkspace: dropOntoWorkspace,
    hasSuggestionForField: hasSuggestionForField,
    editField: editField,
    removeField: removeField,
    indexPattern: currentIndexPattern,
    highlight: fieldSearchHighlight,
    dateRange: dateRange,
    query: query,
    filters: filters
  }), [currentIndexPattern, dateRange, query, filters, dropOntoWorkspace, hasSuggestionForField, editField, removeField]);
  return /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldList, {
    className: "lnsInnerIndexPatternDataPanel",
    isProcessing: isProcessing,
    prepend: /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldListFilters, (0, _extends2.default)({}, fieldListFiltersProps, {
      "data-test-subj": "lnsIndexPattern"
    }))
  }, /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldListGrouped, (0, _extends2.default)({}, fieldListGroupedProps, {
    renderFieldItem: renderFieldItem,
    "data-test-subj": "lnsIndexPattern",
    localStorageKeyPrefix: "lens"
  })));
};
exports.InnerFormBasedDataPanel = InnerFormBasedDataPanel;
const MemoizedDataPanel = /*#__PURE__*/(0, _react.memo)(InnerFormBasedDataPanel);
exports.MemoizedDataPanel = MemoizedDataPanel;