"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensEditConfigurationFlyout = LensEditConfigurationFlyout;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/text-based-languages/public");
var _state_management = require("../../../state_management");
var _utils = require("../../../utils");
var _layer_configuration_section = require("./layer_configuration_section");
var _flyout_wrapper = require("./flyout_wrapper");
var _helpers = require("./helpers");
var _suggestion_panel = require("../../../editor_frame_service/editor_frame/suggestion_panel");
var _get_application_user_messages = require("../../get_application_user_messages");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LensEditConfigurationFlyout({
  attributes,
  coreStart,
  startDependencies,
  visualizationMap,
  datasourceMap,
  datasourceId,
  updatePanelState,
  updateSuggestion,
  setCurrentAttributes,
  closeFlyout,
  saveByRef,
  savedObjectId,
  updateByRefInput,
  output$,
  lensAdapters,
  navigateToLensEditor,
  displayFlyoutHeader,
  canEditTextBasedQuery
}) {
  var _visualization$active, _activeDatasource$sug, _attributes$state$adH, _adHocDataViews$;
  const euiTheme = (0, _eui.useEuiTheme)();
  const previousAttributes = (0, _react.useRef)(attributes);
  const previousAdapters = (0, _react.useRef)(lensAdapters);
  const prevQuery = (0, _react.useRef)(attributes.state.query);
  const [query, setQuery] = (0, _react.useState)(attributes.state.query);
  const [errors, setErrors] = (0, _react.useState)();
  const [isInlineFlyoutVisible, setIsInlineFlyoutVisible] = (0, _react.useState)(true);
  const [isLayerAccordionOpen, setIsLayerAccordionOpen] = (0, _react.useState)(true);
  const [isSuggestionsAccordionOpen, setIsSuggestionsAccordionOpen] = (0, _react.useState)(false);
  const datasourceState = attributes.state.datasourceStates[datasourceId];
  const activeDatasource = datasourceMap[datasourceId];
  const {
    datasourceStates,
    visualization,
    isLoading,
    annotationGroups
  } = (0, _state_management.useLensSelector)(state => state.lens);
  // use the latest activeId, but fallback to attributes
  const activeVisualization = visualizationMap[(_visualization$active = visualization.activeId) !== null && _visualization$active !== void 0 ? _visualization$active : attributes.visualizationType];
  const framePublicAPI = (0, _state_management.useLensSelector)(state => (0, _state_management.selectFramePublicAPI)(state, datasourceMap));
  const suggestsLimitedColumns = activeDatasource === null || activeDatasource === void 0 ? void 0 : (_activeDatasource$sug = activeDatasource.suggestsLimitedColumns) === null || _activeDatasource$sug === void 0 ? void 0 : _activeDatasource$sug.call(activeDatasource, datasourceState);
  const layers = (0, _react.useMemo)(() => activeDatasource.getLayers(datasourceState), [activeDatasource, datasourceState]);
  const dispatch = (0, _state_management.useLensDispatch)();
  (0, _react.useEffect)(() => {
    const s = output$ === null || output$ === void 0 ? void 0 : output$.subscribe(() => {
      var _previousAdapters$cur, _previousAdapters$cur2;
      const activeData = {};
      const adaptersTables = (_previousAdapters$cur = previousAdapters.current) === null || _previousAdapters$cur === void 0 ? void 0 : (_previousAdapters$cur2 = _previousAdapters$cur.tables) === null || _previousAdapters$cur2 === void 0 ? void 0 : _previousAdapters$cur2.tables;
      const [table] = Object.values(adaptersTables || {});
      if (table) {
        layers.forEach(layer => {
          activeData[layer] = table;
        });
        dispatch((0, _state_management.onActiveDataChange)({
          activeData
        }));
      }
    });
    return () => s === null || s === void 0 ? void 0 : s.unsubscribe();
  }, [dispatch, output$, layers]);
  const attributesChanged = (0, _react.useMemo)(() => {
    var _visualizationMap$pre;
    const previousAttrs = previousAttributes.current;
    const datasourceStatesAreSame = datasourceStates[datasourceId].state && previousAttrs.state.datasourceStates[datasourceId] ? datasourceMap[datasourceId].isEqual(previousAttrs.state.datasourceStates[datasourceId], previousAttrs.references, datasourceStates[datasourceId].state, attributes.references) : false;
    const visualizationState = visualization.state;
    const customIsEqual = (_visualizationMap$pre = visualizationMap[previousAttrs.visualizationType]) === null || _visualizationMap$pre === void 0 ? void 0 : _visualizationMap$pre.isEqual;
    const visualizationStateIsEqual = customIsEqual ? (() => {
      try {
        return customIsEqual(previousAttrs.state.visualization, previousAttrs.references, visualizationState, attributes.references, annotationGroups);
      } catch (err) {
        return false;
      }
    })() : (0, _lodash.isEqual)(visualizationState, previousAttrs.state.visualization);
    return !visualizationStateIsEqual || !datasourceStatesAreSame;
  }, [attributes.references, datasourceId, datasourceMap, datasourceStates, visualizationMap, annotationGroups, visualization.state]);
  const onCancel = (0, _react.useCallback)(() => {
    const previousAttrs = previousAttributes.current;
    if (attributesChanged) {
      if (previousAttrs.visualizationType === visualization.activeId) {
        var _datasourceMap$dataso, _datasourceMap$dataso2;
        const currentDatasourceState = datasourceMap[datasourceId].injectReferencesToLayers ? (_datasourceMap$dataso = datasourceMap[datasourceId]) === null || _datasourceMap$dataso === void 0 ? void 0 : (_datasourceMap$dataso2 = _datasourceMap$dataso.injectReferencesToLayers) === null || _datasourceMap$dataso2 === void 0 ? void 0 : _datasourceMap$dataso2.call(_datasourceMap$dataso, previousAttrs.state.datasourceStates[datasourceId], previousAttrs.references) : previousAttrs.state.datasourceStates[datasourceId];
        updatePanelState === null || updatePanelState === void 0 ? void 0 : updatePanelState(currentDatasourceState, previousAttrs.state.visualization);
      } else {
        updateSuggestion === null || updateSuggestion === void 0 ? void 0 : updateSuggestion(previousAttrs);
      }
      if (savedObjectId) {
        updateByRefInput === null || updateByRefInput === void 0 ? void 0 : updateByRefInput(savedObjectId);
      }
    }
    closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
  }, [previousAttributes, attributesChanged, closeFlyout, datasourceMap, datasourceId, updatePanelState, updateSuggestion, savedObjectId, updateByRefInput, visualization]);
  const onApply = (0, _react.useCallback)(() => {
    if (savedObjectId) {
      const dsStates = Object.fromEntries(Object.entries(datasourceStates).map(([id, ds]) => {
        const dsState = ds.state;
        return [id, dsState];
      }));
      const references = (0, _utils.extractReferencesFromState)({
        activeDatasources: Object.keys(datasourceStates).reduce((acc, id) => ({
          ...acc,
          [id]: datasourceMap[id]
        }), {}),
        datasourceStates,
        visualizationState: visualization.state,
        activeVisualization
      });
      const attrs = {
        ...attributes,
        state: {
          ...attributes.state,
          visualization: visualization.state,
          datasourceStates: dsStates
        },
        references
      };
      saveByRef === null || saveByRef === void 0 ? void 0 : saveByRef(attrs);
      updateByRefInput === null || updateByRefInput === void 0 ? void 0 : updateByRefInput(savedObjectId);
    }
    closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
  }, [savedObjectId, closeFlyout, datasourceStates, visualization.state, activeVisualization, attributes, saveByRef, updateByRefInput, datasourceMap]);
  const {
    getUserMessages
  } = (0, _get_application_user_messages.useApplicationUserMessages)({
    coreStart,
    framePublicAPI,
    activeDatasourceId: datasourceId,
    datasourceState: datasourceStates[datasourceId],
    datasource: datasourceMap[datasourceId],
    dispatch,
    visualization: activeVisualization,
    visualizationType: visualization.activeId,
    visualizationState: visualization
  });

  // needed for text based languages mode which works ONLY with adHoc dataviews
  const adHocDataViews = Object.values((_attributes$state$adH = attributes.state.adHocDataViews) !== null && _attributes$state$adH !== void 0 ? _attributes$state$adH : {});
  const runQuery = (0, _react.useCallback)(async q => {
    const attrs = await (0, _helpers.getSuggestions)(q, startDependencies, datasourceMap, visualizationMap, adHocDataViews, setErrors);
    if (attrs) {
      setCurrentAttributes === null || setCurrentAttributes === void 0 ? void 0 : setCurrentAttributes(attrs);
      setErrors([]);
      updateSuggestion === null || updateSuggestion === void 0 ? void 0 : updateSuggestion(attrs);
    }
  }, [startDependencies, datasourceMap, visualizationMap, adHocDataViews, setCurrentAttributes, updateSuggestion]);
  const textBasedMode = (0, _esQuery.isOfAggregateQueryType)(query) ? (0, _esQuery.getAggregateQueryMode)(query) : undefined;
  if (isLoading) return null;
  // Example is the Discover editing where we dont want to render the text based editor on the panel
  if (!canEditTextBasedQuery) {
    return /*#__PURE__*/_react.default.createElement(_flyout_wrapper.FlyoutWrapper, {
      isInlineFlyoutVisible: isInlineFlyoutVisible,
      displayFlyoutHeader: displayFlyoutHeader,
      onCancel: onCancel,
      navigateToLensEditor: navigateToLensEditor,
      onApply: onApply,
      isScrollable: true,
      attributesChanged: attributesChanged
    }, /*#__PURE__*/_react.default.createElement(_layer_configuration_section.LayerConfiguration, {
      getUserMessages: getUserMessages,
      attributes: attributes,
      coreStart: coreStart,
      startDependencies: startDependencies,
      visualizationMap: visualizationMap,
      datasourceMap: datasourceMap,
      datasourceId: datasourceId,
      hasPadding: true,
      framePublicAPI: framePublicAPI,
      setIsInlineFlyoutVisible: setIsInlineFlyoutVisible
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_wrapper.FlyoutWrapper, {
    isInlineFlyoutVisible: isInlineFlyoutVisible,
    displayFlyoutHeader: displayFlyoutHeader,
    onCancel: onCancel,
    navigateToLensEditor: navigateToLensEditor,
    onApply: onApply,
    attributesChanged: attributesChanged,
    language: (0, _esQuery.getLanguageDisplayName)(textBasedMode),
    isScrollable: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
            block-size: 100%;
            .euiFlexItem,
            .euiAccordion,
            .euiAccordion__triggerWrapper,
            .euiAccordion__childWrapper {
              min-block-size: 0;
            }
            .euiAccordion {
              display: flex;
              flex: 1;
              flex-direction: column;
            }
            .euiAccordion__childWrapper {
              overflow-y: auto !important;
              ${(0, _eui.euiScrollBarStyles)(euiTheme)}
              padding-left: ${_uiTheme.euiThemeVars.euiFormMaxWidth};
              margin-left: -${_uiTheme.euiThemeVars.euiFormMaxWidth};
              .euiAccordion-isOpen & {
                block-size: auto !important;
                flex: 1;
              }
            }
          `,
    direction: "column",
    gutterSize: "none"
  }, (0, _esQuery.isOfAggregateQueryType)(query) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "InlineEditingESQLEditor"
  }, /*#__PURE__*/_react.default.createElement(_public.TextBasedLangEditor, {
    query: query,
    onTextLangQueryChange: q => {
      setQuery(q);
      prevQuery.current = q;
    },
    expandCodeEditor: status => {},
    isCodeEditorExpanded: true,
    detectTimestamp: Boolean(adHocDataViews === null || adHocDataViews === void 0 ? void 0 : (_adHocDataViews$ = adHocDataViews[0]) === null || _adHocDataViews$ === void 0 ? void 0 : _adHocDataViews$.timeFieldName),
    errors: errors,
    warning: suggestsLimitedColumns ? _i18n.i18n.translate('xpack.lens.config.configFlyoutCallout', {
      defaultMessage: 'Displaying a limited portion of the available fields. Add more from the configuration panel.'
    }) : undefined,
    hideMinimizeButton: true,
    editorIsInline: true,
    hideRunQueryText: true,
    disableSubmitAction: (0, _lodash.isEqual)(query, prevQuery.current),
    onTextLangQuerySubmit: q => {
      if (q) {
        runQuery(q);
      }
    },
    isDisabled: false
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isLayerAccordionOpen ? 1 : false,
    css: (0, _react2.css)`
                padding-left: ${_uiTheme.euiThemeVars.euiSize};
                padding-right: ${_uiTheme.euiThemeVars.euiSize};
                .euiAccordion__childWrapper {
                  flex: ${isLayerAccordionOpen ? 1 : 'none'}
                }
              }
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "layer-configuration",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: (0, _react2.css)`
                padding: 2px;
              }
            `
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.lens.config.layerConfigurationLabel', {
      defaultMessage: 'Layer configuration'
    }))),
    buttonProps: {
      paddingSize: 'm'
    },
    initialIsOpen: isLayerAccordionOpen,
    forceState: isLayerAccordionOpen ? 'open' : 'closed',
    onToggle: status => {
      if (status && isSuggestionsAccordionOpen) {
        setIsSuggestionsAccordionOpen(!status);
      }
      setIsLayerAccordionOpen(!isLayerAccordionOpen);
    }
  }, /*#__PURE__*/_react.default.createElement(_layer_configuration_section.LayerConfiguration, {
    attributes: attributes,
    getUserMessages: getUserMessages,
    coreStart: coreStart,
    startDependencies: startDependencies,
    visualizationMap: visualizationMap,
    datasourceMap: datasourceMap,
    datasourceId: datasourceId,
    framePublicAPI: framePublicAPI,
    setIsInlineFlyoutVisible: setIsInlineFlyoutVisible
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isSuggestionsAccordionOpen ? 1 : false,
    "data-test-subj": "InlineEditingSuggestions",
    css: (0, _react2.css)`
                border-top: ${_uiTheme.euiThemeVars.euiBorderThin};
                border-bottom: ${_uiTheme.euiThemeVars.euiBorderThin};
                padding-left: ${_uiTheme.euiThemeVars.euiSize};
                padding-right: ${_uiTheme.euiThemeVars.euiSize};
                .euiAccordion__childWrapper {
                  flex: ${isSuggestionsAccordionOpen ? 1 : 'none'}
                }
              }
            `
  }, /*#__PURE__*/_react.default.createElement(_suggestion_panel.SuggestionPanel, {
    ExpressionRenderer: startDependencies.expressions.ReactExpressionRenderer,
    datasourceMap: datasourceMap,
    visualizationMap: visualizationMap,
    frame: framePublicAPI,
    core: coreStart,
    nowProvider: startDependencies.data.nowProvider,
    showOnlyIcons: true,
    wrapSuggestions: true,
    isAccordionOpen: isSuggestionsAccordionOpen,
    toggleAccordionCb: status => {
      if (!status && isLayerAccordionOpen) {
        setIsLayerAccordionOpen(status);
      }
      setIsSuggestionsAccordionOpen(!isSuggestionsAccordionOpen);
    }
  })))));
}