"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStaticColumn = getStaticColumn;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getStaticColumn(id, baseLayer, config) {
  const {
    label,
    ...params
  } = config;
  return {
    linkToLayers: [],
    columnOrder: [...baseLayer.columnOrder, id],
    columns: {
      [id]: {
        label: label !== null && label !== void 0 ? label : 'Reference',
        dataType: 'number',
        operationType: 'static_value',
        isStaticValue: true,
        isBucketed: false,
        scale: 'ratio',
        params,
        references: [],
        customLabel: true
      }
    },
    sampling: 1,
    incompleteColumns: {}
  };
}