"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormulaColumn = getFormulaColumn;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getFormulaColumn(id, config, dataView, formulaAPI, baseLayer) {
  const {
    value,
    ...rest
  } = config;
  const formulaLayer = formulaAPI.insertOrReplaceFormulaColumn(id, {
    formula: value,
    ...rest
  }, baseLayer || {
    columnOrder: [],
    columns: {}
  }, dataView);
  if (!formulaLayer) {
    throw new Error('Error generating the data layer for the chart');
  }
  return formulaLayer;
}