"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getXYVisualizationState = exports.XYChart = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../utils");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACCESSOR = 'formula_accessor';

// This needs be more specialized by `preferredSeriesType`

class XYChart {
  constructor(chartConfig) {
    (0, _defineProperty2.default)(this, "_layers", null);
    this.chartConfig = chartConfig;
  }
  getVisualizationType() {
    return _constants.XY_ID;
  }
  get layers() {
    if (!this._layers) {
      this._layers = Array.isArray(this.chartConfig.layers) ? this.chartConfig.layers : [this.chartConfig.layers];
    }
    return this._layers;
  }
  getLayers() {
    return this.layers.reduce((acc, curr, index) => {
      const layerId = `${_utils.DEFAULT_LAYER_ID}_${index}`;
      const accessorId = `${ACCESSOR}_${index}`;
      return {
        ...acc,
        ...curr.getLayer(layerId, accessorId, this.chartConfig.dataView, this.chartConfig.formulaAPI)
      };
    }, {});
  }
  getVisualizationState() {
    var _this$chartConfig$vis, _this$chartConfig$vis2, _this$chartConfig$vis3, _this$chartConfig$vis4, _this$chartConfig$vis5, _this$chartConfig$vis6, _this$chartConfig$vis7, _this$chartConfig$vis8, _this$chartConfig$vis9, _this$chartConfig$vis10, _this$chartConfig$vis11;
    return {
      ...getXYVisualizationState({
        layers: [...this.chartConfig.layers.map((layerItem, index) => {
          const layerId = `${_utils.DEFAULT_LAYER_ID}_${index}`;
          const accessorId = `${ACCESSOR}_${index}`;
          return layerItem.getLayerConfig(layerId, accessorId);
        })]
      }),
      legend: (_this$chartConfig$vis = (_this$chartConfig$vis2 = this.chartConfig.visualOptions) === null || _this$chartConfig$vis2 === void 0 ? void 0 : _this$chartConfig$vis2.legend) !== null && _this$chartConfig$vis !== void 0 ? _this$chartConfig$vis : {
        isVisible: false,
        position: 'right',
        showSingleSeries: false
      },
      fittingFunction: (_this$chartConfig$vis3 = (_this$chartConfig$vis4 = this.chartConfig.visualOptions) === null || _this$chartConfig$vis4 === void 0 ? void 0 : _this$chartConfig$vis4.missingValues) !== null && _this$chartConfig$vis3 !== void 0 ? _this$chartConfig$vis3 : 'None',
      endValue: (_this$chartConfig$vis5 = this.chartConfig.visualOptions) === null || _this$chartConfig$vis5 === void 0 ? void 0 : _this$chartConfig$vis5.endValues,
      curveType: (_this$chartConfig$vis6 = this.chartConfig.visualOptions) === null || _this$chartConfig$vis6 === void 0 ? void 0 : _this$chartConfig$vis6.lineInterpolation,
      emphasizeFitting: !((_this$chartConfig$vis7 = this.chartConfig.visualOptions) !== null && _this$chartConfig$vis7 !== void 0 && _this$chartConfig$vis7.showDottedLine),
      valueLabels: (_this$chartConfig$vis8 = this.chartConfig.visualOptions) === null || _this$chartConfig$vis8 === void 0 ? void 0 : _this$chartConfig$vis8.valueLabels,
      axisTitlesVisibilitySettings: (_this$chartConfig$vis9 = (_this$chartConfig$vis10 = this.chartConfig.visualOptions) === null || _this$chartConfig$vis10 === void 0 ? void 0 : _this$chartConfig$vis10.axisTitlesVisibilitySettings) !== null && _this$chartConfig$vis9 !== void 0 ? _this$chartConfig$vis9 : {
        x: false,
        yLeft: false,
        yRight: true
      },
      yLeftExtent: (_this$chartConfig$vis11 = this.chartConfig.visualOptions) === null || _this$chartConfig$vis11 === void 0 ? void 0 : _this$chartConfig$vis11.yLeftExtent
    };
  }
  getReferences() {
    return this.layers.flatMap((p, index) => {
      const layerId = `${_utils.DEFAULT_LAYER_ID}_${index}`;
      return p.getReference(layerId, this.chartConfig.dataView);
    });
  }
  getDataViews() {
    return [this.chartConfig.dataView, ...this.chartConfig.layers.map(p => p.getDataView()).filter(x => !!x)];
  }
  getTitle() {
    var _ref, _this$chartConfig$tit;
    return (_ref = (_this$chartConfig$tit = this.chartConfig.title) !== null && _this$chartConfig$tit !== void 0 ? _this$chartConfig$tit : this.layers[0].getName()) !== null && _ref !== void 0 ? _ref : '';
  }
}
exports.XYChart = XYChart;
const getXYVisualizationState = custom => ({
  legend: {
    isVisible: false,
    position: 'right',
    showSingleSeries: false
  },
  valueLabels: 'show',
  yLeftScale: 'linear',
  tickLabelsVisibilitySettings: {
    x: true,
    yLeft: true,
    yRight: true
  },
  labelsOrientation: {
    x: 0,
    yLeft: 0,
    yRight: 0
  },
  gridlinesVisibilitySettings: {
    x: true,
    yLeft: true,
    yRight: true
  },
  preferredSeriesType: 'line',
  valuesInLegend: false,
  hideEndzones: true,
  ...custom
});
exports.getXYVisualizationState = getXYVisualizationState;