"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricChart = void 0;
var _utils = require("../utils");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACCESSOR = 'metric_formula_accessor';
class MetricChart {
  constructor(chartConfig) {
    this.chartConfig = chartConfig;
  }
  getVisualizationType() {
    return _constants.METRIC_ID;
  }
  getLayers() {
    return this.chartConfig.layers.getLayer(_utils.DEFAULT_LAYER_ID, ACCESSOR, this.chartConfig.dataView, this.chartConfig.formulaAPI);
  }
  getVisualizationState() {
    return this.chartConfig.layers.getLayerConfig(_utils.DEFAULT_LAYER_ID, ACCESSOR);
  }
  getReferences() {
    return this.chartConfig.layers.getReference(_utils.DEFAULT_LAYER_ID, this.chartConfig.dataView);
  }
  getDataViews() {
    return [this.chartConfig.dataView, this.chartConfig.layers.getDataView()].filter(x => !!x);
  }
  getTitle() {
    var _this$chartConfig$tit;
    return (_this$chartConfig$tit = this.chartConfig.title) !== null && _this$chartConfig$tit !== void 0 ? _this$chartConfig$tit : '';
  }
}
exports.MetricChart = MetricChart;