"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchDynamicTreeView = void 0;
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchDynamicTreeView = (query, groupBy, index, enabled) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const cachingKeys = [_constants.QUERY_KEY_PROCESS_EVENTS, query, groupBy, index];
  return (0, _reactQuery.useInfiniteQuery)(cachingKeys, async ({
    pageParam = 0
  }) => {
    if (groupBy === _helpers.KUBERNETES_COLLECTION_FIELDS.clusterId) {
      const {
        buckets
      } = await http.get(_constants.MULTI_TERMS_AGGREGATE_ROUTE, {
        version: '1',
        query: {
          query: JSON.stringify(query),
          groupBys: JSON.stringify([{
            field: groupBy
          }, {
            field: _constants.ORCHESTRATOR_CLUSTER_NAME,
            missing: ''
          }]),
          page: pageParam,
          perPage: 50,
          index
        }
      });
      return {
        buckets: buckets.map(bucket => ({
          ...bucket,
          key_as_string: bucket.key[1],
          key: bucket.key[0]
        }))
      };
    }
    return await http.get(_constants.AGGREGATE_ROUTE, {
      version: _constants.CURRENT_API_VERSION,
      query: {
        query: JSON.stringify(query),
        groupBy,
        page: pageParam,
        perPage: 50,
        index
      }
    });
  }, {
    enabled,
    getNextPageParam: (lastPage, pages) => lastPage.hasNextPage ? pages.length : undefined
  });
};
exports.useFetchDynamicTreeView = useFetchDynamicTreeView;