"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NAME_COLUMN_TEST_ID = exports.LOADING_TEST_ID = exports.ContainerNameWidget = exports.COUNT_COLUMN_TEST_ID = exports.CONTAINER_NAME_TABLE_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _container_name_row = require("./container_name_row");
var _hooks = require("../../hooks");
var _add_timerange_and_default_filter_to_query = require("../../utils/add_timerange_and_default_filter_to_query");
var _hooks2 = require("./hooks");
var _constants = require("../../../common/constants");
var _translations = require("../../../common/translations");
var _add_commas_to_number = require("../../utils/add_commas_to_number");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOADING_TEST_ID = 'kubernetesSecurity:containerNameWidgetLoading';
exports.LOADING_TEST_ID = LOADING_TEST_ID;
const NAME_COLUMN_TEST_ID = 'kubernetesSecurity:containerImageNameSessionNameColumn';
exports.NAME_COLUMN_TEST_ID = NAME_COLUMN_TEST_ID;
const COUNT_COLUMN_TEST_ID = 'kubernetesSecurity:containerImageNameSessionCountColumn';
exports.COUNT_COLUMN_TEST_ID = COUNT_COLUMN_TEST_ID;
const CONTAINER_NAME_TABLE_TEST_ID = 'kubernetesSecurity:containerNameSessionTable';
exports.CONTAINER_NAME_TABLE_TEST_ID = CONTAINER_NAME_TABLE_TEST_ID;
const ContainerNameWidget = ({
  widgetKey,
  indexPattern,
  globalFilter,
  groupedBy,
  countBy
}) => {
  const [sortField, setSortField] = (0, _react.useState)('count');
  const [sortDirection, setSortDirection] = (0, _react.useState)('desc');
  const styles = (0, _styles.useStyles)();
  const filterQueryWithTimeRange = (0, _react.useMemo)(() => {
    return (0, _add_timerange_and_default_filter_to_query.addTimerangeAndDefaultFilterToQuery)(globalFilter.filterQuery, globalFilter.startDate, globalFilter.endDate);
  }, [globalFilter.filterQuery, globalFilter.startDate, globalFilter.endDate]);
  const {
    data,
    fetchNextPage,
    isFetchingNextPage,
    isLoading
  } = (0, _hooks2.useFetchContainerNameData)(filterQueryWithTimeRange, widgetKey, groupedBy, countBy, indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.title, sortDirection);
  const onTableChange = (0, _react.useCallback)(({
    sort = {}
  }) => {
    // @ts-ignore
    const {
      field: sortingField,
      direction: sortingDirection
    } = sort;
    setSortField(sortingField);
    setSortDirection(sortingDirection);
  }, []);
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    },
    enableAllColumns: true
  };
  const {
    getFilterForValueButton,
    getFilterOutValueButton,
    getCopyButton,
    filterManager
  } = (0, _hooks.useSetFilter)();
  const filterButtons = (0, _react.useMemo)(() => {
    var _data$pages, _data$pages2;
    const result = {
      filterForButtons: (data === null || data === void 0 ? void 0 : (_data$pages = data.pages) === null || _data$pages === void 0 ? void 0 : _data$pages.map(aggsData => {
        return aggsData === null || aggsData === void 0 ? void 0 : aggsData.buckets.map(aggData => {
          return getFilterForValueButton({
            field: _constants.CONTAINER_IMAGE_NAME,
            filterManager,
            size: 'xs',
            onClick: () => {},
            onFilterAdded: () => {},
            ownFocus: false,
            showTooltip: true,
            value: aggData.key
          });
        });
      }).flat()) || [],
      filterOutButtons: (data === null || data === void 0 ? void 0 : (_data$pages2 = data.pages) === null || _data$pages2 === void 0 ? void 0 : _data$pages2.map(aggsData => {
        return aggsData === null || aggsData === void 0 ? void 0 : aggsData.buckets.map(aggData => {
          return getFilterOutValueButton({
            field: _constants.CONTAINER_IMAGE_NAME,
            filterManager,
            size: 'xs',
            onClick: () => {},
            onFilterAdded: () => {},
            ownFocus: false,
            showTooltip: true,
            value: aggData.key
          });
        });
      }).flat()) || []
    };
    return result;
  }, [data, getFilterForValueButton, getFilterOutValueButton, filterManager]);
  const copyToClipboardButtons = (0, _react.useMemo)(() => {
    var _data$pages3;
    const result = {
      copyButtons: (data === null || data === void 0 ? void 0 : (_data$pages3 = data.pages) === null || _data$pages3 === void 0 ? void 0 : _data$pages3.map(aggsData => {
        return aggsData === null || aggsData === void 0 ? void 0 : aggsData.buckets.map(aggData => {
          return getCopyButton({
            field: _constants.CONTAINER_IMAGE_NAME,
            size: 'xs',
            onClick: () => {},
            ownFocus: false,
            showTooltip: true,
            value: aggData.key
          });
        });
      }).flat()) || []
    };
    return result;
  }, [data, getCopyButton]);
  const containerNameArray = (0, _react.useMemo)(() => {
    var _data$pages4;
    return data ? data === null || data === void 0 ? void 0 : (_data$pages4 = data.pages) === null || _data$pages4 === void 0 ? void 0 : _data$pages4.map(aggsData => {
      return aggsData === null || aggsData === void 0 ? void 0 : aggsData.buckets.map(aggData => {
        var _aggData$count_by_agg, _aggData$count_by_agg2;
        return {
          name: aggData.key,
          count: (0, _add_commas_to_number.addCommasToNumber)((_aggData$count_by_agg = (_aggData$count_by_agg2 = aggData.count_by_aggs) === null || _aggData$count_by_agg2 === void 0 ? void 0 : _aggData$count_by_agg2.value) !== null && _aggData$count_by_agg !== void 0 ? _aggData$count_by_agg : 0)
        };
      });
    }).flat() : [];
  }, [data]);
  const columns = (0, _react.useMemo)(() => {
    return [{
      field: 'name',
      name: _translations.CONTAINER_NAME_SESSION,
      'data-test-subj': NAME_COLUMN_TEST_ID,
      render: name => {
        const indexHelper = containerNameArray.findIndex(obj => {
          return obj.name === name;
        });
        return /*#__PURE__*/_react.default.createElement(_container_name_row.ContainerNameRow, {
          name: name,
          filterButtonIn: filterButtons.filterForButtons[indexHelper],
          filterButtonOut: filterButtons.filterOutButtons[indexHelper],
          copyToClipboardButton: copyToClipboardButtons.copyButtons[indexHelper]
        });
      },
      align: 'left',
      width: '67%',
      sortable: false
    }, {
      field: 'count',
      name: _translations.CONTAINER_NAME_SESSION_COUNT_COLUMN,
      width: '33%',
      'data-test-subj': COUNT_COLUMN_TEST_ID,
      render: count => {
        return /*#__PURE__*/_react.default.createElement("span", {
          css: styles.countValue
        }, count);
      },
      sortable: true,
      align: 'right'
    }];
  }, [filterButtons.filterForButtons, filterButtons.filterOutButtons, copyToClipboardButtons.copyButtons, containerNameArray, styles]);
  const scrollerRef = (0, _react.useRef)(null);
  (0, _hooks.useScroll)({
    div: scrollerRef.current,
    handler: (pos, endReached) => {
      if (!isFetchingNextPage && endReached) {
        fetchNextPage();
      }
    }
  });
  const cellProps = (0, _react.useMemo)(() => {
    return {
      css: styles.cellPad
    };
  }, [styles.cellPad]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": CONTAINER_NAME_TABLE_TEST_ID,
    className: "eui-yScroll",
    css: styles.container,
    ref: scrollerRef
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    "data-test-subj": LOADING_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "aria-label": _translations.CONTAINER_NAME_SESSION_ARIA_LABEL,
    items: containerNameArray,
    columns: columns,
    sorting: sorting,
    onChange: onTableChange,
    cellProps: cellProps
  }));
};
exports.ContainerNameWidget = ContainerNameWidget;