"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderCompleteDispatcher = void 0;
exports.dispatchRenderComplete = dispatchRenderComplete;
exports.dispatchRenderStart = dispatchRenderStart;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dispatchEvent = (el, eventName) => {
  el.dispatchEvent(new CustomEvent(eventName, {
    bubbles: true
  }));
};
function dispatchRenderComplete(el) {
  dispatchEvent(el, 'renderComplete');
}
function dispatchRenderStart(el) {
  dispatchEvent(el, 'renderStart');
}

/**
 * Should call `dispatchComplete()` when UI block has finished loading its data and has
 * completely rendered. Should `dispatchInProgress()` every time UI block
 * starts loading data again. At the start it is assumed that UI block is loading
 * so it dispatches "in progress" automatically, so you need to call `setRenderComplete`
 * at least once.
 *
 * This is used for reporting to know that UI block is ready, so
 * it can take a screenshot. It is also used in functional tests to know that
 * page has stabilized.
 */
class RenderCompleteDispatcher {
  constructor(el) {
    (0, _defineProperty2.default)(this, "count", 0);
    (0, _defineProperty2.default)(this, "el", void 0);
    this.setEl(el);
  }
  setEl(el) {
    if (this.el !== el) {
      this.el = el;
      this.count = 0;
    }
    if (el) this.dispatchInProgress();
  }
  dispatchInProgress() {
    if (!this.el) return;
    this.el.setAttribute('data-render-complete', 'false');
    this.el.setAttribute('data-rendering-count', String(this.count));
    dispatchRenderStart(this.el);
  }
  dispatchComplete() {
    if (!this.el) return;
    this.count++;
    this.el.setAttribute('data-render-complete', 'true');
    this.el.setAttribute('data-rendering-count', String(this.count));
    dispatchRenderComplete(this.el);
  }
  dispatchError() {
    if (!this.el) return;
    this.count++;
    this.el.setAttribute('data-render-complete', 'true');
    this.el.setAttribute('data-rendering-count', String(this.count));
  }
  setTitle(title) {
    if (!this.el) return;
    this.el.setAttribute('data-title', title);
  }
}
exports.RenderCompleteDispatcher = RenderCompleteDispatcher;