"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withKibana = exports.useKibana = exports.createKibanaReactContext = exports.context = exports.KibanaContextProvider = void 0;
var React = _interopRequireWildcard(require("react"));
var _overlays = require("../overlays");
var _notifications = require("../notifications");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  useMemo,
  useContext,
  createElement,
  createContext
} = React;
const defaultContextValue = {
  services: {},
  overlays: (0, _overlays.createReactOverlays)({}),
  notifications: (0, _notifications.createNotifications)({})
};
const context = createContext(defaultContextValue);
exports.context = context;
const useKibana = () => useContext(context);
exports.useKibana = useKibana;
const withKibana = type => {
  const EnhancedType = props => {
    const kibana = useKibana();
    return /*#__PURE__*/React.createElement(type, {
      ...props,
      kibana
    });
  };
  return EnhancedType;
};
exports.withKibana = withKibana;
const createKibanaReactContext = services => {
  const value = {
    services,
    overlays: (0, _overlays.createReactOverlays)(services),
    notifications: (0, _notifications.createNotifications)(services)
  };
  const Provider = ({
    services: newServices = {},
    children
  }) => {
    const oldValue = useKibana();
    const {
      value: newValue
    } = useMemo(() => createKibanaReactContext({
      ...services,
      ...oldValue.services,
      ...newServices
    }), [services, oldValue, newServices]);
    const newProvider = createElement(context.Provider, {
      value: newValue,
      children
    });
    return newProvider;
  };
  return {
    value,
    Provider,
    Consumer: context.Consumer
  };
};
exports.createKibanaReactContext = createKibanaReactContext;
const {
  Provider: KibanaContextProvider
} = createKibanaReactContext({});
exports.KibanaContextProvider = KibanaContextProvider;