"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Registry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Registry {
  // eslint-disable-next-line @typescript-eslint/ban-types

  constructor(prop = 'name') {
    (0, _defineProperty2.default)(this, "_prop", void 0);
    (0, _defineProperty2.default)(this, "_indexed", void 0);
    if (typeof prop !== 'string') throw new Error('Registry property name must be a string');
    this._prop = prop;
    this._indexed = new Object();
  }
  wrapper(obj) {
    // @ts-ignore
    return obj;
  }
  register(fn) {
    const obj = typeof fn === 'function' ? fn() : fn;

    // @ts-ignore
    if (typeof obj !== 'object' || !obj[this._prop]) {
      throw new Error(`Registered functions must return an object with a ${this._prop} property`);
    }

    // @ts-ignore
    this._indexed[obj[this._prop].toLowerCase()] = this.wrapper(obj);
  }
  toJS() {
    return Object.keys(this._indexed).reduce((acc, key) => {
      // @ts-ignore
      acc[key] = this.get(key);
      return acc;
    }, {});
  }
  toArray() {
    return Object.keys(this._indexed).map(key => this.get(key));
  }
  get(name) {
    // @ts-ignore
    if (name === undefined) return null;
    const lowerCaseName = name.toLowerCase();
    // @ts-ignore
    return this._indexed[lowerCaseName] ? (0, _lodash.clone)(this._indexed[lowerCaseName]) : null;
  }
  getProp() {
    return this._prop;
  }
  reset() {
    this._indexed = new Object();
  }
}
exports.Registry = Registry;