"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorViewChooser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class InspectorViewChooser extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isSelectorOpen: false
    });
    (0, _defineProperty2.default)(this, "toggleSelector", () => {
      this.setState(prev => ({
        isSelectorOpen: !prev.isSelectorOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closeSelector", () => {
      this.setState({
        isSelectorOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderView", (view, index) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: index,
        onClick: () => {
          this.props.onViewSelected(view);
          this.closeSelector();
        },
        toolTipContent: view.help,
        toolTipPosition: "left",
        "data-test-subj": `inspectorViewChooser${view.title}`
      }, view.title);
    });
  }
  renderViewButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: this.toggleSelector,
      "data-test-subj": "inspectorViewChooser"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.view",
      defaultMessage: "View: {viewName}",
      values: {
        viewName: this.props.selectedView.title
      }
    }));
  }
  renderSingleView() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: this.props.selectedView.help
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.view",
      defaultMessage: "View: {viewName}",
      values: {
        viewName: this.props.selectedView.title
      }
    }));
  }
  render() {
    const {
      views
    } = this.props;
    if (views.length < 2) {
      return this.renderSingleView();
    }
    const triggerButton = this.renderViewButton();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "inspectorViewChooser",
      button: triggerButton,
      isOpen: this.state.isSelectorOpen,
      closePopover: this.closeSelector,
      panelPaddingSize: "none",
      anchorPosition: "downRight",
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: views.map(this.renderView)
    }));
  }
}
exports.InspectorViewChooser = InspectorViewChooser;
(0, _defineProperty2.default)(InspectorViewChooser, "propTypes", {
  views: _propTypes.default.array.isRequired,
  onViewSelected: _propTypes.default.func.isRequired,
  selectedView: _propTypes.default.object.isRequired
});