"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternSelectFormRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function IndexPatternSelectFormRowUi(props) {
  const {
    controlIndex,
    indexPatternId,
    intl,
    onChange
  } = props;
  const selectId = `indexPatternSelect-${controlIndex}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: selectId,
    label: intl.formatMessage({
      id: 'inputControl.editor.indexPatternSelect.patternLabel',
      defaultMessage: 'Index Pattern'
    })
  }, /*#__PURE__*/_react.default.createElement(props.IndexPatternSelect, {
    placeholder: intl.formatMessage({
      id: 'inputControl.editor.indexPatternSelect.patternPlaceholder',
      defaultMessage: 'Select index pattern...'
    }),
    indexPatternId: indexPatternId,
    onChange: onChange,
    "data-test-subj": selectId
  }));
}
const IndexPatternSelectFormRow = (0, _i18nReact.injectI18n)(IndexPatternSelectFormRowUi);
exports.IndexPatternSelectFormRow = IndexPatternSelectFormRow;