"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsExplorerViewSavedObjectRT = exports.metricsExplorerSavedObjectTimeOptionsRT = exports.metricsExplorerSavedObjectOptionsRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsExplorerSavedObjectChartTypeRT = rt.keyof({
  line: null,
  area: null,
  bar: null
});
const metricsExplorerYAxisModeRT = rt.keyof({
  fromZero: null,
  auto: null
});
const metricsExplorerSavedObjectChartOptionsRT = rt.type({
  yAxisMode: metricsExplorerYAxisModeRT,
  type: metricsExplorerSavedObjectChartTypeRT,
  stack: rt.boolean
});
const metricsExplorerSavedObjectTimeOptionsRT = rt.type({
  from: rt.string,
  to: rt.string,
  interval: rt.string
});
exports.metricsExplorerSavedObjectTimeOptionsRT = metricsExplorerSavedObjectTimeOptionsRT;
const metricsExplorerSavedObjectOptionsMetricRT = rt.intersection([rt.UnknownRecord, rt.partial({
  rate: rt.boolean,
  color: rt.string,
  label: rt.string
})]);
const metricExplorerSavedObjectOptionsRequiredRT = rt.type({
  aggregation: rt.string,
  metrics: rt.array(metricsExplorerSavedObjectOptionsMetricRT)
});
const metricExplorerSavedObjectOptionsOptionalRT = rt.partial({
  limit: rt.number,
  groupBy: rt.union([rt.string, rt.array(rt.string)]),
  filterQuery: rt.string,
  source: rt.string,
  forceInterval: rt.boolean,
  dropLastBucket: rt.boolean
});
const metricsExplorerSavedObjectOptionsRT = rt.intersection([metricExplorerSavedObjectOptionsRequiredRT, metricExplorerSavedObjectOptionsOptionalRT]);
exports.metricsExplorerSavedObjectOptionsRT = metricsExplorerSavedObjectOptionsRT;
const metricExplorerViewsSavedObjectStateRT = rt.type({
  chartOptions: metricsExplorerSavedObjectChartOptionsRT,
  currentTimerange: metricsExplorerSavedObjectTimeOptionsRT,
  options: metricsExplorerSavedObjectOptionsRT
});
const metricsExplorerViewSavedObjectAttributesRT = rt.intersection([metricExplorerViewsSavedObjectStateRT, rt.type({
  name: _ioTsUtils.nonEmptyStringRt
}), rt.partial({
  isDefault: rt.boolean,
  isStatic: rt.boolean
})]);
const metricsExplorerViewSavedObjectRT = rt.intersection([rt.type({
  id: rt.string,
  attributes: metricsExplorerViewSavedObjectAttributesRT
}), rt.partial({
  version: rt.string,
  updated_at: _ioTsUtils.isoToEpochRt
})]);
exports.metricsExplorerViewSavedObjectRT = metricsExplorerViewSavedObjectRT;