"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSourceConfigurationFormState = void 0;
var _react = require("react");
var _indices_configuration_form_state = require("./indices_configuration_form_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSourceConfigurationFormState = configuration => {
  const indicesConfigurationFormState = (0, _indices_configuration_form_state.useIndicesConfigurationFormState)({
    initialFormState: (0, _react.useMemo)(() => configuration ? {
      name: configuration.name,
      description: configuration.description,
      metricAlias: configuration.metricAlias,
      anomalyThreshold: configuration.anomalyThreshold
    } : undefined, [configuration])
  });
  const errors = (0, _react.useMemo)(() => [...indicesConfigurationFormState.errors], [indicesConfigurationFormState.errors]);
  const resetForm = (0, _react.useCallback)(() => {
    indicesConfigurationFormState.resetForm();
  }, [indicesConfigurationFormState]);
  const isFormDirty = (0, _react.useMemo)(() => indicesConfigurationFormState.isFormDirty, [indicesConfigurationFormState.isFormDirty]);
  const isFormValid = (0, _react.useMemo)(() => indicesConfigurationFormState.isFormValid, [indicesConfigurationFormState.isFormValid]);
  const formState = (0, _react.useMemo)(() => ({
    name: indicesConfigurationFormState.formState.name,
    description: indicesConfigurationFormState.formState.description,
    metricAlias: indicesConfigurationFormState.formState.metricAlias,
    anomalyThreshold: indicesConfigurationFormState.formState.anomalyThreshold
  }), [indicesConfigurationFormState.formState]);
  const formStateChanges = (0, _react.useMemo)(() => ({
    name: indicesConfigurationFormState.formStateChanges.name,
    description: indicesConfigurationFormState.formStateChanges.description,
    metricAlias: indicesConfigurationFormState.formStateChanges.metricAlias,
    anomalyThreshold: indicesConfigurationFormState.formStateChanges.anomalyThreshold
  }), [indicesConfigurationFormState.formStateChanges]);
  return {
    errors,
    formState,
    formStateChanges,
    isFormDirty,
    isFormValid,
    indicesConfigurationProps: indicesConfigurationFormState.fieldProps,
    resetForm
  };
};
exports.useSourceConfigurationFormState = useSourceConfigurationFormState;