"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicesConfigurationFormState = void 0;
var _react = require("react");
var _input_fields = require("./input_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndicesConfigurationFormState = ({
  initialFormState = defaultFormState
}) => {
  const [formStateChanges, setFormStateChanges] = (0, _react.useState)({});
  const resetForm = (0, _react.useCallback)(() => setFormStateChanges({}), []);
  const formState = (0, _react.useMemo)(() => ({
    ...initialFormState,
    ...formStateChanges
  }), [initialFormState, formStateChanges]);
  const nameFieldProps = (0, _react.useMemo)(() => (0, _input_fields.createInputFieldProps)({
    errors: (0, _input_fields.aggregateValidationErrors)(_input_fields.validateInputFieldNotEmpty)(formState.name),
    name: 'name',
    onChange: name => setFormStateChanges(changes => ({
      ...changes,
      name
    })),
    value: formState.name
  }), [formState.name]);
  const metricAliasFieldProps = (0, _react.useMemo)(() => (0, _input_fields.createInputFieldProps)({
    errors: (0, _input_fields.aggregateValidationErrors)(_input_fields.validateInputFieldNotEmpty, _input_fields.validateInputFieldHasNotEmptyEntries, _input_fields.validateInputFieldHasNotEmptySpaces)(formState.metricAlias),
    name: 'metricAlias',
    onChange: metricAlias => setFormStateChanges(changes => ({
      ...changes,
      metricAlias
    })),
    value: formState.metricAlias
  }), [formState.metricAlias]);
  const anomalyThresholdFieldProps = (0, _react.useMemo)(() => (0, _input_fields.createInputRangeFieldProps)({
    errors: (0, _input_fields.aggregateValidationErrors)(_input_fields.validateInputFieldNotEmpty)(formState.anomalyThreshold),
    name: 'anomalyThreshold',
    onChange: anomalyThreshold => setFormStateChanges(changes => ({
      ...changes,
      anomalyThreshold
    })),
    value: formState.anomalyThreshold
  }), [formState.anomalyThreshold]);
  const fieldProps = (0, _react.useMemo)(() => ({
    name: nameFieldProps,
    metricAlias: metricAliasFieldProps,
    anomalyThreshold: anomalyThresholdFieldProps
  }), [nameFieldProps, metricAliasFieldProps, anomalyThresholdFieldProps]);
  const errors = (0, _react.useMemo)(() => Object.values(fieldProps).reduce((accumulatedErrors, {
    error
  }) => [...accumulatedErrors, ...error], []), [fieldProps]);
  const isFormValid = (0, _react.useMemo)(() => errors.length <= 0, [errors]);
  const isFormDirty = (0, _react.useMemo)(() => Object.keys(formStateChanges).length > 0, [formStateChanges]);
  return {
    errors,
    fieldProps,
    formState,
    formStateChanges,
    isFormDirty,
    isFormValid,
    resetForm
  };
};
exports.useIndicesConfigurationFormState = useIndicesConfigurationFormState;
const defaultFormState = {
  name: '',
  description: '',
  metricAlias: '',
  anomalyThreshold: 0
};