"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorPalette = void 0;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createColorPalette = (name = 'cool', steps = 10) => {
  switch (name) {
    case 'temperature':
      return (0, _eui.euiPaletteForTemperature)(steps);
    case 'status':
      return (0, _eui.euiPaletteForStatus)(steps);
    case 'warm':
      return (0, _eui.euiPaletteWarm)(steps);
    case 'positive':
      return (0, _eui.euiPalettePositive)(steps);
    case 'negative':
      return (0, _eui.euiPaletteNegative)(steps);
    default:
      return (0, _eui.euiPaletteCool)(steps);
  }
};
const getColorPalette = (name = 'cool', steps = 10, reverse = false) => {
  return reverse ? createColorPalette(name, steps).reverse() : createColorPalette(name, steps);
};
exports.getColorPalette = getColorPalette;