"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInventoryMetricFormatter = void 0;
var _lodash = require("lodash");
var _lib = require("../../../../lib/lib");
var _snapshot_api = require("../../../../../common/http_api/snapshot_api");
var _create_formatter_for_metric = require("../../metrics_explorer/components/helpers/create_formatter_for_metric");
var _formatters = require("../../../../../common/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRIC_FORMATTERS = {
  count: {
    formatter: _lib.InfraFormatterType.number,
    template: '{{value}}'
  },
  cpu: {
    formatter: _lib.InfraFormatterType.percent,
    template: '{{value}}'
  },
  diskIOReadBytes: {
    formatter: _lib.InfraFormatterType.bytes,
    template: '{{value}}/s'
  },
  diskIOWriteBytes: {
    formatter: _lib.InfraFormatterType.bytes,
    template: '{{value}}/s'
  },
  diskLatency: {
    formatter: _lib.InfraFormatterType.number,
    template: '{{value}} ms'
  },
  diskSpaceUsage: {
    formatter: _lib.InfraFormatterType.percent,
    template: '{{value}}'
  },
  memory: {
    formatter: _lib.InfraFormatterType.percent,
    template: '{{value}}'
  },
  memoryFree: {
    formatter: _lib.InfraFormatterType.bytes,
    template: '{{value}}'
  },
  memoryTotal: {
    formatter: _lib.InfraFormatterType.bytes,
    template: '{{value}}'
  },
  normalizedLoad1m: {
    formatter: _lib.InfraFormatterType.percent,
    template: '{{value}}'
  },
  rx: {
    formatter: _lib.InfraFormatterType.bits,
    template: '{{value}}/s'
  },
  tx: {
    formatter: _lib.InfraFormatterType.bits,
    template: '{{value}}/s'
  },
  logRate: {
    formatter: _lib.InfraFormatterType.abbreviatedNumber,
    template: '{{value}}/s'
  },
  s3BucketSize: {
    formatter: _lib.InfraFormatterType.bytes,
    template: '{{value}}'
  },
  s3TotalRequests: {
    formatter: _lib.InfraFormatterType.abbreviatedNumber,
    template: '{{value}}'
  },
  s3NumberOfObjects: {
    formatter: _lib.InfraFormatterType.abbreviatedNumber,
    template: '{{value}}'
  },
  s3UploadBytes: {
    formatter: _lib.InfraFormatterType.bytes,
    template: '{{value}}'
  },
  s3DownloadBytes: {
    formatter: _lib.InfraFormatterType.bytes,
    template: '{{value}}'
  },
  sqsOldestMessage: {
    formatter: _lib.InfraFormatterType.number,
    template: '{{value}} seconds'
  },
  rdsLatency: {
    formatter: _lib.InfraFormatterType.number,
    template: '{{value}} ms'
  }
};
const createInventoryMetricFormatter = metric => val => {
  if (_snapshot_api.SnapshotCustomMetricInputRT.is(metric)) {
    const formatter = (0, _create_formatter_for_metric.createFormatterForMetric)(metric);
    return (0, _lodash.isNumber)(val) ? formatter(val) : val;
  }
  const metricFormatter = (0, _lodash.get)(METRIC_FORMATTERS, metric.type, METRIC_FORMATTERS.count);
  if (val == null || !metricFormatter) {
    return '';
  }
  const formatter = (0, _formatters.createFormatter)(metricFormatter.formatter, metricFormatter.template);
  return formatter(val);
};
exports.createInventoryMetricFormatter = createInventoryMetricFormatter;