"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleSortControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _dropdown_button = require("../dropdown_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LABELS = {
  name: _i18n.i18n.translate('xpack.infra.waffle.sortNameLabel', {
    defaultMessage: 'Name'
  }),
  value: _i18n.i18n.translate('xpack.infra.waffle.sort.valueLabel', {
    defaultMessage: 'Metric value'
  })
};
const WaffleSortControls = ({
  sort,
  onChange
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(currentIsOpen => !currentIsOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), []);
  const label = LABELS[sort.by];
  const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
    label: _i18n.i18n.translate('xpack.infra.waffle.sortLabel', {
      defaultMessage: 'Sort by'
    }),
    onClick: togglePopover,
    "data-test-subj": 'waffleSortByDropdown'
  }, label);
  const selectName = (0, _react.useCallback)(() => {
    onChange({
      ...sort,
      by: 'name'
    });
    closePopover();
  }, [closePopover, onChange, sort]);
  const selectValue = (0, _react.useCallback)(() => {
    onChange({
      ...sort,
      by: 'value'
    });
    closePopover();
  }, [closePopover, onChange, sort]);
  const toggleSort = (0, _react.useCallback)(() => {
    onChange({
      ...sort,
      direction: sort.direction === 'asc' ? 'desc' : 'asc'
    });
    closePopover();
  }, [closePopover, sort, onChange]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    title: '',
    items: [{
      name: LABELS.name,
      icon: sort.by === 'name' ? 'check' : 'empty',
      onClick: selectName,
      'data-test-subj': 'waffleSortByName'
    }, {
      name: LABELS.value,
      icon: sort.by === 'value' ? 'check' : 'empty',
      onClick: selectValue,
      'data-test-subj': 'waffleSortByValue'
    }]
  }], [sort.by, selectName, selectValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    id: "sortPopover",
    button: button,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }), /*#__PURE__*/_react.default.createElement(SwitchContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.infra.waffle.sortDirectionLabel', {
      defaultMessage: 'Reverse direction'
    }),
    checked: sort.direction === 'desc',
    onChange: toggleSort,
    "data-test-subj": 'waffleSortByDirection'
  })));
};
exports.WaffleSortControls = WaffleSortControls;
const SwitchContainer = (0, _common.withTheme)(({
  children,
  theme
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: theme === null || theme === void 0 ? void 0 : theme.eui.euiSizeM,
      borderTop: `1px solid ${theme === null || theme === void 0 ? void 0 : theme.eui.euiBorderColor}`
    }
  }, children);
});