"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _metrics_source = require("../../../../containers/metrics_source");
var _autocomplete_field = require("../../../../components/autocomplete_field");
var _with_kuery_autocompletion = require("../../../../containers/with_kuery_autocompletion");
var _use_waffle_filters = require("../hooks/use_waffle_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchBar = () => {
  const {
    createDerivedIndexPattern
  } = (0, _metrics_source.useSourceContext)();
  const {
    applyFilterQueryFromKueryExpression,
    filterQueryDraft,
    isFilterQueryDraftValid,
    setFilterQueryDraftFromKueryExpression
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  return /*#__PURE__*/_react.default.createElement(_with_kuery_autocompletion.WithKueryAutocompletion, {
    indexPattern: createDerivedIndexPattern()
  }, ({
    isLoadingSuggestions,
    loadSuggestions,
    suggestions
  }) => /*#__PURE__*/_react.default.createElement(_autocomplete_field.AutocompleteField, {
    isLoadingSuggestions: isLoadingSuggestions,
    isValid: isFilterQueryDraftValid,
    loadSuggestions: loadSuggestions,
    onChange: setFilterQueryDraftFromKueryExpression,
    onSubmit: applyFilterQueryFromKueryExpression,
    placeholder: _i18n.i18n.translate('xpack.infra.homePage.toolbar.kqlSearchFieldPlaceholder', {
      defaultMessage: 'Search for infrastructure data… (e.g. host.name:host-1)'
    }),
    suggestions: suggestions,
    value: filterQueryDraft ? filterQueryDraft : '',
    autoFocus: true
  }));
};
exports.SearchBar = SearchBar;