"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabId = exports.TabIds = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _use_url_state = require("../../../../utils/use_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAB_ID_URL_STATE_KEY = 'tabId';
const useTabId = (initialValue = TabIds.METRICS) => {
  return (0, _use_url_state.useUrlState)({
    defaultState: initialValue,
    decodeUrlState: makeDecodeUrlState(initialValue),
    encodeUrlState,
    urlStateKey: TAB_ID_URL_STATE_KEY
  });
};
exports.useTabId = useTabId;
const TabIdRT = rt.union([rt.literal('alerts'), rt.literal('logs'), rt.literal('metrics')]);
let TabIds;
exports.TabIds = TabIds;
(function (TabIds) {
  TabIds["ALERTS"] = "alerts";
  TabIds["LOGS"] = "logs";
  TabIds["METRICS"] = "metrics";
})(TabIds || (exports.TabIds = TabIds = {}));
const encodeUrlState = TabIdRT.encode;
const makeDecodeUrlState = initialValue => value => {
  return (0, _pipeable.pipe)(TabIdRT.decode(value), (0, _Either.fold)((0, _function.constant)(initialValue), _function.identity));
};