"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsTabContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/logs-shared-plugin/public");
var _loading = require("../../../../../../components/loading");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_logs_search_url_state = require("../../../hooks/use_logs_search_url_state");
var _logs_link_to_stream = require("./logs_link_to_stream");
var _logs_search_bar = require("./logs_search_bar");
var _build = require("../../../../../../utils/filters/build");
var _use_log_view_reference = require("../../../../../../hooks/use_log_view_reference");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsTabContent = () => {
  const [filterQuery] = (0, _use_logs_search_url_state.useLogsSearchUrlState)();
  const {
    getDateRangeAsTimestamp
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    from,
    to
  } = (0, _react.useMemo)(() => getDateRangeAsTimestamp(), [getDateRangeAsTimestamp]);
  const {
    hostNodes,
    loading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const hostsFilterQuery = (0, _react.useMemo)(() => (0, _build.buildCombinedHostsFilter)({
    field: 'host.name',
    values: hostNodes.map(p => p.name)
  }), [hostNodes]);
  const {
    logViewReference: logView,
    loading: logViewLoading
  } = (0, _use_log_view_reference.useLogViewReference)({
    id: 'hosts-logs-view',
    extraFields: ['host.name']
  });
  const logsLinkToStreamQuery = (0, _react.useMemo)(() => {
    const hostsFilterQueryParam = createHostsFilterQueryParam(hostNodes.map(p => p.name));
    if (filterQuery.query && hostsFilterQueryParam) {
      return `${filterQuery.query} and ${hostsFilterQueryParam}`;
    }
    return filterQuery.query || hostsFilterQueryParam;
  }, [filterQuery.query, hostNodes]);
  if (loading || logViewLoading || !logView) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        height: 300
      },
      direction: "column",
      alignItems: "stretch"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      width: "100%",
      height: "100%",
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsViewPage.tabs.logs.loadingEntriesLabel",
        defaultMessage: "Loading entries"
      })
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "hostsView-logs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_logs_search_bar.LogsSearchBar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_logs_link_to_stream.LogsLinkToStream, {
    startTime: from,
    endTime: to,
    query: logsLinkToStreamQuery,
    logView: logView
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.LogStream, {
    height: 500,
    logView: logView,
    startTimestamp: from,
    endTimestamp: to,
    filters: [hostsFilterQuery],
    query: filterQuery,
    showFlyoutAction: true
  })));
};
exports.LogsTabContent = LogsTabContent;
const createHostsFilterQueryParam = hostNodes => {
  if (!hostNodes.length) {
    return '';
  }
  const joinedHosts = hostNodes.join(' or ');
  const hostsQueryParam = `host.name:(${joinedHosts})`;
  return hostsQueryParam;
};