"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hosts_table = require("./hosts_table");
var _kpi_grid = require("./kpis/kpi_grid");
var _tabs = require("./tabs/tabs");
var _use_alerts_query = require("../hooks/use_alerts_query");
var _use_hosts_view = require("../hooks/use_hosts_view");
var _use_hosts_table = require("../hooks/use_hosts_table");
var _error_callout = require("./error_callout");
var _use_unified_search = require("../hooks/use_unified_search");
var _use_host_count = require("../hooks/use_host_count");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostsContent = () => {
  const {
    error
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error ? /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error,
    hasDetailsModal: true
  }) : /*#__PURE__*/_react.default.createElement(_use_hosts_view.HostsViewProvider, null, /*#__PURE__*/_react.default.createElement(_use_hosts_table.HostsTableProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_use_host_count.HostCountProvider, null, /*#__PURE__*/_react.default.createElement(_kpi_grid.KPIGrid, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_hosts_table.HostsTable, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_use_alerts_query.AlertsQueryProvider, null, /*#__PURE__*/_react.default.createElement(_tabs.Tabs, null)))))));
};
exports.HostsContent = HostsContent;