"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _metrics_source = require("../../../../../containers/metrics_source");
var _use_unified_search = require("../../hooks/use_unified_search");
var _asset_details = require("../../../../../components/asset_details/asset_details");
var _asset_details_tabs = require("../../../../../common/asset_details_config/asset_details_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutWrapper = ({
  node: {
    name
  },
  closeFlyout
}) => {
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const {
    parsedDateRange
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  return source ? /*#__PURE__*/_react.default.createElement(_asset_details.AssetDetails, {
    assetId: name,
    assetName: name,
    assetType: "host",
    dateRange: parsedDateRange,
    overrides: {
      metadata: {
        showActionsColumn: true
      }
    },
    tabs: _asset_details_tabs.commonFlyoutTabs,
    links: ['apmServices', 'nodeDetails'],
    renderMode: {
      mode: 'flyout',
      closeFlyout
    },
    metricAlias: source.configuration.metricAlias
  }) : null;
};
exports.FlyoutWrapper = FlyoutWrapper;