"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsPageTemplate = ({
  hasData = true,
  isDataLoading = false,
  'data-test-subj': _dataTestSubj,
  ...pageTemplateProps
}) => {
  const {
    services: {
      observabilityShared: {
        navigation: {
          PageTemplate
        }
      },
      docLinks
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = (0, _public.useKibana)().services;
  const basePath = http.basePath.get();
  const noDataConfig = hasData ? undefined : {
    solution: _i18n.i18n.translate('xpack.infra.logs.noDataConfig.solutionName', {
      defaultMessage: 'Observability'
    }),
    action: {
      beats: {
        title: _i18n.i18n.translate('xpack.infra.logs.noDataConfig.beatsCard.title', {
          defaultMessage: 'Add a logging integration'
        }),
        description: _i18n.i18n.translate('xpack.infra.logs.noDataConfig.beatsCard.description', {
          defaultMessage: 'Use the Elastic Agent or Beats to send logs to Elasticsearch. We make it easy with integrations for many popular systems and apps.'
        }),
        href: basePath + `/app/integrations/browse`
      }
    },
    docsLink: docLinks.links.observability.guide
  };
  return /*#__PURE__*/_react.default.createElement(PageTemplate, (0, _extends2.default)({
    "data-test-subj": hasData ? _dataTestSubj : 'noDataPage',
    noDataConfig: noDataConfig,
    isPageDataLoaded: isDataLoading === false
  }, pageTemplateProps));
};
exports.LogsPageTemplate = LogsPageTemplate;