"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateContextInUrl = exports.positionStateInUrlRT = exports.initializeFromUrl = exports.defaultPositionStateKey = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _public = require("@kbn/kibana-utils-plugin/public");
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _function = require("fp-ts/lib/function");
var _time = require("../../../../common/time");
var _runtime_types = require("../../../../common/runtime_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultPositionStateKey = 'logPosition';
exports.defaultPositionStateKey = defaultPositionStateKey;
const updateContextInUrl = ({
  urlStateStorage,
  positionStateKey = defaultPositionStateKey
}) => (context, _event) => {
  if (!('latestPosition' in context)) {
    throw new Error('Missing keys from context needed to sync to the URL');
  }
  urlStateStorage.set(positionStateKey, positionStateInUrlRT.encode({
    position: context.latestPosition ? (0, _time.pickTimeKey)(context.latestPosition) : null
  }), {
    replace: true
  });
};
exports.updateContextInUrl = updateContextInUrl;
const initializeFromUrl = ({
  positionStateKey = defaultPositionStateKey,
  urlStateStorage,
  toastsService
}) => (_context, _event) => send => {
  var _urlStateStorage$get;
  const positionQueryValueFromUrl = (_urlStateStorage$get = urlStateStorage.get(positionStateKey)) !== null && _urlStateStorage$get !== void 0 ? _urlStateStorage$get : {};
  const initialUrlValues = (0, _function.pipe)(decodePositionQueryValueFromUrl(positionQueryValueFromUrl), Either.map(({
    position
  }) => {
    var _position$tiebreaker;
    return {
      targetPosition: position !== null && position !== void 0 && position.time ? {
        time: position.time,
        tiebreaker: (_position$tiebreaker = position.tiebreaker) !== null && _position$tiebreaker !== void 0 ? _position$tiebreaker : 0
      } : null
    };
  }), Either.map(({
    targetPosition
  }) => ({
    targetPosition,
    latestPosition: targetPosition
  })));
  if (Either.isLeft(initialUrlValues)) {
    (0, _public.withNotifyOnErrors)(toastsService).onGetError((0, _runtime_types.createPlainError)((0, _runtime_types.formatErrors)(initialUrlValues.left)));
    send({
      type: 'INITIALIZED_FROM_URL',
      targetPosition: null,
      latestPosition: null
    });
  } else {
    var _initialUrlValues$rig, _initialUrlValues$rig2;
    send({
      type: 'INITIALIZED_FROM_URL',
      targetPosition: (_initialUrlValues$rig = initialUrlValues.right.targetPosition) !== null && _initialUrlValues$rig !== void 0 ? _initialUrlValues$rig : null,
      latestPosition: (_initialUrlValues$rig2 = initialUrlValues.right.latestPosition) !== null && _initialUrlValues$rig2 !== void 0 ? _initialUrlValues$rig2 : null
    });
  }
};
exports.initializeFromUrl = initializeFromUrl;
const positionStateInUrlRT = rt.partial({
  position: rt.union([rt.partial(_time.minimalTimeKeyRT.props), rt.null])
});
exports.positionStateInUrlRT = positionStateInUrlRT;
const decodePositionQueryValueFromUrl = queryValueFromUrl => {
  return positionStateInUrlRT.decode(queryValueFromUrl);
};