"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataMetricsAdHocDataView = exports.generateDataViewId = exports.TIMESTAMP_FIELD = exports.DATA_VIEW_PREFIX = void 0;
var _uuid = require("uuid");
var _useAsyncRetry = _interopRequireDefault(require("react-use/lib/useAsyncRetry"));
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMESTAMP_FIELD = '@timestamp';
exports.TIMESTAMP_FIELD = TIMESTAMP_FIELD;
const DATA_VIEW_PREFIX = 'infra_metrics';
exports.DATA_VIEW_PREFIX = DATA_VIEW_PREFIX;
const generateDataViewId = indexPattern => {
  // generates a unique but the same uuid as long as the index pattern doesn't change
  return `${DATA_VIEW_PREFIX}_${(0, _uuid.v5)(indexPattern, _uuid.v5.DNS)}`;
};
exports.generateDataViewId = generateDataViewId;
const useDataMetricsAdHocDataView = ({
  metricAlias
}) => {
  const {
    services: {
      dataViews
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const state = (0, _useAsyncRetry.default)(() => {
    return dataViews.create({
      id: generateDataViewId(metricAlias),
      title: metricAlias,
      timeFieldName: TIMESTAMP_FIELD
    });
  }, [metricAlias]);
  const {
    value: dataView,
    loading,
    error,
    retry
  } = state;
  return {
    metricAlias,
    dataView,
    loading,
    loadDataView: retry,
    error
  };
};
exports.useDataMetricsAdHocDataView = useDataMetricsAdHocDataView;