"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricHostsModule = exports.DEFAULT_K8S_PARTITION_FIELD = void 0;
var _i18n = require("@kbn/i18n");
var _k8s_memory_usage = _interopRequireDefault(require("@kbn/ml-plugin/server/models/data_recognizer/modules/metrics_ui_k8s/ml/k8s_memory_usage.json"));
var _datafeed_k8s_memory_usage = _interopRequireDefault(require("@kbn/ml-plugin/server/models/data_recognizer/modules/metrics_ui_k8s/ml/datafeed_k8s_memory_usage.json"));
var _k8s_network_in = _interopRequireDefault(require("@kbn/ml-plugin/server/models/data_recognizer/modules/metrics_ui_k8s/ml/k8s_network_in.json"));
var _datafeed_k8s_network_in = _interopRequireDefault(require("@kbn/ml-plugin/server/models/data_recognizer/modules/metrics_ui_k8s/ml/datafeed_k8s_network_in.json"));
var _k8s_network_out = _interopRequireDefault(require("@kbn/ml-plugin/server/models/data_recognizer/modules/metrics_ui_k8s/ml/k8s_network_out.json"));
var _datafeed_k8s_network_out = _interopRequireDefault(require("@kbn/ml-plugin/server/models/data_recognizer/modules/metrics_ui_k8s/ml/datafeed_k8s_network_out.json"));
var _infra_ml_cleanup = require("../../infra_ml_cleanup");
var _ml_get_jobs_summary_api = require("../../api/ml_get_jobs_summary_api");
var _ml_get_module = require("../../api/ml_get_module");
var _ml_setup_module_api = require("../../api/ml_setup_module_api");
var _infra_ml = require("../../../../../common/infra_ml");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_K8S_PARTITION_FIELD = 'kubernetes.namespace';
exports.DEFAULT_K8S_PARTITION_FIELD = DEFAULT_K8S_PARTITION_FIELD;
const moduleId = 'metrics_ui_k8s';
const moduleName = _i18n.i18n.translate('xpack.infra.ml.metricsModuleName', {
  defaultMessage: 'Metrics anomanly detection'
});
const moduleDescription = _i18n.i18n.translate('xpack.infra.ml.metricsHostModuleDescription', {
  defaultMessage: 'Use Machine Learning to automatically detect anomalous log entry rates.'
});
const getJobIds = (spaceId, sourceId) => _infra_ml.metricsK8SJobTypes.reduce((accumulatedJobIds, jobType) => ({
  ...accumulatedJobIds,
  [jobType]: (0, _infra_ml.getJobId)(spaceId, sourceId, jobType)
}), {});
const getJobSummary = async (spaceId, sourceId, fetch) => {
  const response = await (0, _ml_get_jobs_summary_api.callJobsSummaryAPI)({
    spaceId,
    sourceId,
    jobTypes: _infra_ml.metricsK8SJobTypes
  }, fetch);
  const jobIds = Object.values(getJobIds(spaceId, sourceId));
  return response.filter(jobSummary => jobIds.includes(jobSummary.id));
};
const getModuleDefinition = async fetch => {
  return await (0, _ml_get_module.callGetMlModuleAPI)(moduleId, fetch);
};
const setUpModule = async (setUpModuleArgs, fetch) => {
  const {
    start,
    end,
    filter,
    moduleSourceConfiguration: {
      spaceId,
      sourceId,
      indices
    },
    partitionField
  } = setUpModuleArgs;
  const indexNamePattern = indices.join(',');
  const jobIds = ['k8s_memory_usage', 'k8s_network_in', 'k8s_network_out'];
  const jobOverrides = jobIds.map(id => {
    const {
      job: defaultJobConfig
    } = getDefaultJobConfigs(id);

    // eslint-disable-next-line @typescript-eslint/naming-convention
    const analysis_config = {
      ...defaultJobConfig.analysis_config
    };
    if (partitionField) {
      analysis_config.detectors[0].partition_field_name = partitionField;
      if (analysis_config.influencers.indexOf(partitionField) === -1) {
        analysis_config.influencers.push(partitionField);
      }
    }
    return {
      job_id: id,
      data_description: {
        time_field: _constants.TIMESTAMP_FIELD
      },
      analysis_config,
      custom_settings: {
        metrics_source_config: {
          indexPattern: indexNamePattern,
          timestampField: _constants.TIMESTAMP_FIELD,
          bucketSpan: _infra_ml.bucketSpan
        }
      }
    };
  });
  const datafeedOverrides = jobIds.map(id => {
    const {
      datafeed: defaultDatafeedConfig
    } = getDefaultJobConfigs(id);
    const config = {
      ...defaultDatafeedConfig
    };
    if (filter) {
      const query = JSON.parse(filter);
      config.query.bool = {
        ...config.query.bool,
        ...query.bool
      };
    }
    if (!partitionField || id === 'k8s_memory_usage') {
      // Since the host memory usage doesn't have custom aggs, we don't need to do anything to add a partition field
      return {
        ...config,
        job_id: id
      };
    }

    // Because the ML K8s jobs ship with a default partition field of {kubernetes.namespace}, ignore that agg and wrap it in our own agg.
    const innerAggregation = defaultDatafeedConfig.aggregations[DEFAULT_K8S_PARTITION_FIELD].aggregations;

    // If we have a partition field, we need to change the aggregation to do a terms agg to partition the data at the top level
    const aggregations = {
      [partitionField]: {
        terms: {
          field: partitionField,
          size: 25 // 25 is arbitratry and only used to keep the number of buckets to a managable level in the event that the user choose a high cardinality partition field.
        },

        aggregations: {
          ...innerAggregation
        }
      }
    };
    return {
      ...config,
      job_id: id,
      aggregations
    };
  });
  return (0, _ml_setup_module_api.callSetupMlModuleAPI)({
    moduleId,
    start,
    end,
    spaceId,
    sourceId,
    indexPattern: indexNamePattern,
    jobOverrides,
    datafeedOverrides
  }, fetch);
};
const getDefaultJobConfigs = jobId => {
  switch (jobId) {
    case 'k8s_memory_usage':
      return {
        datafeed: _datafeed_k8s_memory_usage.default,
        job: _k8s_memory_usage.default
      };
    case 'k8s_network_in':
      return {
        datafeed: _datafeed_k8s_network_in.default,
        job: _k8s_network_in.default
      };
    case 'k8s_network_out':
      return {
        datafeed: _datafeed_k8s_network_out.default,
        job: _k8s_network_out.default
      };
  }
};
const cleanUpModule = async (spaceId, sourceId, fetch) => {
  return await (0, _infra_ml_cleanup.cleanUpJobsAndDatafeeds)(spaceId, sourceId, _infra_ml.metricsK8SJobTypes, fetch);
};
const metricHostsModule = {
  moduleId,
  moduleName,
  moduleDescription,
  jobTypes: _infra_ml.metricsK8SJobTypes,
  bucketSpan: _infra_ml.bucketSpan,
  getJobIds,
  getJobSummary,
  getModuleDefinition,
  setUpModule,
  cleanUpModule
};
exports.metricHostsModule = metricHostsModule;