"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogAnalysisSetupFlyoutStateContext = exports.useLogAnalysisSetupFlyoutState = exports.moduleIds = exports.LogAnalysisSetupFlyoutStateProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const moduleIds = ['logs_ui_analysis', 'logs_ui_categories'];
exports.moduleIds = moduleIds;
const useLogAnalysisSetupFlyoutState = ({
  initialFlyoutView = {
    view: 'hidden'
  }
}) => {
  const [flyoutView, setFlyoutView] = (0, _react.useState)(initialFlyoutView);
  const closeFlyout = (0, _react.useCallback)(() => setFlyoutView({
    view: 'hidden'
  }), []);
  const showModuleList = (0, _react.useCallback)(() => setFlyoutView({
    view: 'moduleList'
  }), []);
  const showModuleSetup = (0, _react.useCallback)(module => {
    setFlyoutView({
      view: 'moduleSetup',
      module
    });
  }, [setFlyoutView]);
  return {
    closeFlyout,
    flyoutView,
    setFlyoutView,
    showModuleList,
    showModuleSetup
  };
};
exports.useLogAnalysisSetupFlyoutState = useLogAnalysisSetupFlyoutState;
const [LogAnalysisSetupFlyoutStateProvider, useLogAnalysisSetupFlyoutStateContext] = (0, _constate.default)(useLogAnalysisSetupFlyoutState);
exports.useLogAnalysisSetupFlyoutStateContext = useLogAnalysisSetupFlyoutStateContext;
exports.LogAnalysisSetupFlyoutStateProvider = LogAnalysisSetupFlyoutStateProvider;